#include "Bounce2.h"
#include "DHT.h"
#include "LiquidCrystal.h"

#define setBUTTON 13
#define upBUTTON 12
#define downBUTTON 11

Bounce setBUTTONDebouncer;
Bounce upBUTTONDebouncer;
Bounce downBUTTONDebouncer;

volatile  int up = 30;

#define DHTPIN 2
#define DHTTYPE DHT21

DHT dht(DHTPIN, DHTTYPE);
LiquidCrystal lcd(8, 7, 6, 5, 4, 3);

const int temprelay = 10;
const int humidityrelay = 9;


void setup() {
  lcd.begin(16, 2);
  lcd.clear();

  dht.begin();

    setBUTTONDebouncer.attach (setBUTTON);
    setBUTTONDebouncer.interval(50);
    
    upBUTTONDebouncer.attach (upBUTTON);
    upBUTTONDebouncer.interval(50);

    downBUTTONDebouncer.attach (downBUTTON);
    downBUTTONDebouncer.interval(50);

    
      pinMode (setBUTTON, INPUT_PULLUP);
      pinMode (upBUTTON, INPUT_PULLUP);
      pinMode (downBUTTON, INPUT_PULLUP);
}

void loop() {
  
setBUTTONDebouncer.update();
upBUTTONDebouncer.update();
downBUTTONDebouncer.update();


if (setBUTTONDebouncer.fell ())
{
   lcd.clear();
   lcd.print("set Humidity:");
   
}

 if(upBUTTONDebouncer.fell())
 {
  up++;
  
   lcd.setCursor(7,2);
   lcd.print(up);

 }

   
  

  delay(1);

  float h = dht.readHumidity();
  float t = dht.readTemperature();

  if (isnan(h) || isnan(t)) {
    lcd.setCursor(0,0);
    lcd.print("Failed to read ");
    lcd.setCursor(0,1);
    lcd.print("from DHT sensor!");
    return;
  }
   lcd.print("Humidity:");
   lcd.setCursor(10,0);
   lcd.print(h);
   lcd.setCursor(15,0);
   lcd.print("%");
   lcd.setCursor(1,1);
   lcd.print("Temp:");
   lcd.setCursor(7,1);
   lcd.print(t);
   lcd.setCursor(12,1);
   lcd.print(" *C ");
}
