#include "Prtype.h"
#include "Uartport.h"
#include "SY08.h"


UINT8  UartRxBuff[MaxPakgeLen];
UINT8  UartTxBuff[MaxPakgeLen];
INT32  RevDtaNum;
INT32  RevDtaOffset; 
 

//һ׵ģŵĳʱƣҪڴͨ 
//ͬʱʹöʱ 
INT32 TimeOutCnt0;
INT32 TimeOutCnt1;
 
#define  TimeOutSet0(tMs) do{\
	TimeOutCnt0=tMs*SYSFrequency/1000/TimeAdjust;\
}while(0); 
#define TimeOutCheck0()  TimeOutCnt0--

#define  TimeOutSet1(tMs) do{\
	TimeOutCnt1=tMs*SYSFrequency/1000/TimeAdjust;\
}while(0); 
#define TimeOutCheck1()  TimeOutCnt1--

#define UartTimeOut (SYSFrequency/UartBaudRate*10*10)//10ֽʱ 

UINT8 ClearRxBuff(void)
{
    UINT16 i;
    for (i=0;i<MaxPakgeLen;i++)
	   UartRxBuff[i]=0;
	RevDtaNum=0;
	RevDtaOffset=0;
}
UINT8 ClearTxBuff(void)
{
    UINT16 i;
    for (i=0;i<MaxPakgeLen;i++)
	   UartTxBuff[i]=0;
}

//UartжϷ 
static void UartInterruptCallback(void)
{
    //Ҫͻ޸ 
	union UART_INTSTAT_REG IntFlag;
	volatile struct UART_REGS * pUart = GetUartRegs(0);
	IntFlag = pUart->INTSTAT;		
	pUart->INTCLR.all = IntFlag.all;	

	if(IntFlag.bit.RxIntf || IntFlag.bit.RxOerrIntf)	
	{
		while(pUart->CSTAT.bit.RxAvl)	
		{
            if (RevDtaNum<MaxPakgeLen)   //жݽbuffǷ 
            {
            	UartRxBuff[RevDtaNum++]=pUart->RXREG; // 
            }  
			else	
			{
				UINT8 temp;
				temp = pUart->RXREG;
			}
			TimeOutSet1(UartTimeOut);
		}
	}	
}

//Uartʼ 
UINT8 UartPortInit(void)
{
    ClearRxBuff(); 
    ClearTxBuff();
    TimeOutCnt0=0;
    TimeOutCnt1=0;
    
 //²ҪͻԼ޸   
    STRUCT_UART_FORMAT PRT_FRAME;
    PRT_FRAME.BaudRate=UartBaudRate;
    PRT_FRAME.CharBit=UartChar;
    PRT_FRAME.Parity=0;
    PRT_FRAME.StopBit=UartStopBit;
    PRT_FRAME.TxMode=0;
    UartInit(0,UART0_MAP_A18_19,(STRUCT_UART_FORMAT)PRT_FRAME,NULL,NULL,UartInterruptCallback);
    return 0;
}
 
//Uart 
static UINT8 UARTSendByte(UINT8 pDat) 
{
    //Ҫû 
    UartSendByte(0,pDat);
}

UINT8 UartDataSend(UINT8*pDatBuf,UINT16 DataLen)
{
    UINT16 n = 0;

    while (n<DataLen) 
    {
    	UARTSendByte(*pDatBuf);
    	pDatBuf++;
    	n++;
    }     
	return 0;
}
//Uart 
UINT8 UartDataRev(UINT8*pDatBuf,UINT16 DataLen,UINT16 TimeOutMs)
{
    UINT16 i;
    TimeOutSet0(TimeOutMs);
    do{
         if (RevDtaNum-RevDtaOffset>=DataLen)    
         {
            for (i=0;i<DataLen;i++)
               pDatBuf[i]=UartRxBuff[RevDtaOffset+i];
            RevDtaOffset+=DataLen;
            return RT_OK;
         }     
    }
    while (TimeOutCheck0()>0);
	return RT_OVERTIME;
}






