$regfile = "m8def.dat"
$crystal = 8000000
$hwstack = 100
$swstack = 100
$framesize = 100

Config Portc.5 = Output                                     ' for TM1640 clock
Config Portc.4 = Output                                     ' for TM1640 data

Tm1640_clk Alias Portc.5
Tm1640_dout Alias Portc.4
Tm1640_din Alias Pinc.4

Declare Sub Tm1640_wrbyte(byval Bdata As Byte)
Declare Sub Tm1640_on()
Declare Sub Tm1640_off()
Declare Sub Tm1640_start()
Declare Sub Tm1640_stop()
Declare Sub Tm1640_ack()
'========================================================================
'
'     Start main
'
'========================================================================
Dim L As Byte
Tm1640_start : Tm1640_wrbyte &H40 : Tm1640_ack : Tm1640_stop       '40 auto 44 fix
Tm1640_on
Do

Tm1640_start : Tm1640_wrbyte &HC0 : Tm1640_ack : Tm1640_wrbyte &B00000111 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC1 : Tm1640_ack : Tm1640_wrbyte &B01111101 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC2 : Tm1640_ack : Tm1640_wrbyte &B01101101 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC3 : Tm1640_ack : Tm1640_wrbyte &B01100110 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC4 : Tm1640_ack : Tm1640_wrbyte &B1000_0000 : Tm1640_ack : Tm1640_stop       'Clock d
Tm1640_start : Tm1640_wrbyte &HC5 : Tm1640_ack : Tm1640_wrbyte &B1000_0000 : Tm1640_ack : Tm1640_stop       'Degree d

Tm1640_start : Tm1640_wrbyte &HC6 : Tm1640_ack : Tm1640_wrbyte &B01001111 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC7 : Tm1640_ack : Tm1640_wrbyte &B01011011 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC8 : Tm1640_ack : Tm1640_wrbyte &B00000110 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HC9 : Tm1640_ack : Tm1640_wrbyte &B101_11111 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HCA : Tm1640_ack : Tm1640_wrbyte &B1000_0000 : Tm1640_ack : Tm1640_stop       'Clock u
Tm1640_start : Tm1640_wrbyte &HCB : Tm1640_ack : Tm1640_wrbyte &B1000_0000 : Tm1640_ack : Tm1640_stop       'Degree u

Tm1640_start : Tm1640_wrbyte &HCC : Tm1640_ack : Tm1640_wrbyte &B0000_0000 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HCD : Tm1640_ack : Tm1640_wrbyte &B0000_0000 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HCE : Tm1640_ack : Tm1640_wrbyte &B0000_0000 : Tm1640_ack : Tm1640_stop
Tm1640_start : Tm1640_wrbyte &HCF : Tm1640_ack : Tm1640_wrbyte &B0000_0000 : Tm1640_ack : Tm1640_stop


For L = &H88 To &H8F : Tm1640_start : Tm1640_wrbyte L : Tm1640_ack : Tm1640_stop : Waitms 40 : Next
For L = &H8F To &H88 Step -1 : Tm1640_start : Tm1640_wrbyte L : Tm1640_ack : Tm1640_stop : Waitms 40 : Next

Loop
End
'=========================================================================
'
'     Subroutines
'
'========================================================================

Sub Tm1640_wrbyte(byval Bdata As Byte)
   Local Bbitcounter As Byte
   For Bbitcounter = 0 To 7                                 'LSB first0-6 bedoone h
        Reset Tm1640_clk
         Tm1640_dout = Bdata.bbitcounter
        Waitus 3
        Set Tm1640_clk
        Waitus 3
   Next
End Sub
'************************************
Sub Tm1640_ack()
   Reset Tm1640_clk
   Reset Tm1640_dout
   Waitus 5
   Reset Tm1640_dout
   Bitwait Tm1640_din , Reset
End Sub
'************************************
Sub Tm1640_off()
   Tm1640_start
   Tm1640_wrbyte &H80                                       'Turn display off
   Tm1640_ack
   Tm1640_stop
End Sub

Sub Tm1640_on()
   Tm1640_start
   Tm1640_wrbyte &H88                                       'Turn display on and set PWM for brightness to 25%
   Tm1640_ack
   Tm1640_stop
End Sub
'************************************
Sub Tm1640_start()
   Set Tm1640_clk
   Set Tm1640_dout
   Waitus 2
   Reset Tm1640_dout
End Sub
Sub Tm1640_stop()
   Reset Tm1640_clk
   Waitus 2
   Reset Tm1640_dout
   Waitus 2
   Set Tm1640_clk
   Waitus 2
   Set Tm1640_dout
End Sub
'********************************************************************************
