/*
 * MFRC522 - Library to use ARDUINO RFID MODULE KIT 13.56 MHZ WITH TAGS SPI W AND R BY COOQROBOT.
 * The library file MFRC522.h has a wealth of useful info. Please read it.
 * The functions are documented in MFRC522.cpp.
 *
 * Based on code Dr.Leong   ( WWW.B2CQSHOP.COM )
 * Created by Miguel Balboa (circuitito.com), Jan, 2012.
 * Rewritten by Søren Thing Andersen (access.thing.dk), fall of 2013 (Translation to English, refactored, comments, anti collision, cascade levels.)
 * Released into the public domain.
 *
 * This sample shows how to setup a block on a MIFARE Classic PICC to be in "Value Block" mode.
 * In Value Block mode the operations Increment/Decrement/Restore and Transfer can be used.
 * 
 * Pin layout should be as follows:
 * Signal     Pin              Pin
 *            Arduino Uno      MFRC522 board
 * -----------------------------------------
 * Reset      9                RST
 * SPI SS     10               SDA
 * SPI MOSI   11               MOSI
 * SPI MISO   12               MISO
 * SPI SCK    13               SCK
 *
 * The reader can be found on eBay for around 5 dollars. Search for "mf-rc522" on ebay.com. 
 */

#include <SPI.h>
#include <MFRC522.h>

#define SS_PIN 53
#define RST_PIN 11
MFRC522 mfrc522(SS_PIN, RST_PIN);	// Create MFRC522 instance.

unsigned char command, devnull;
unsigned int returnLength;

void setup() {
	// Serial.begin(115200);
  Serial1.begin(9600);
  Serial.println("Waiting for Card\n");
  //Serial1.begin(9600);

  Serial1.write(0x02); //Send the command to RFID, please refer to RFID manual

}

void loop() // run over and over

{

  if (Serial1.available())
    {
      Serial.print("\n\rCARD SERIAL: ");
      for (unsigned int i=0; i<4 ;i=i){
        //Serial.print("2");   
        if (Serial1.available()) {
            //Serial.print("\n\ri is: ");Serial.print(i);Serial.print(" ");
            Serial.print(Serial1.read(),HEX); //Display the Serial Number in HEX
            i++;
          }
        }
       
       Serial.println("\n\rRead Card Make...");
       Serial1.write(0xAB);Serial1.write(0x02);Serial1.write(0x01);
       
       Get_Reply();
       
       Serial1.write(0x02); //Send the command to RFID, please refer to RFID manual
    }
    
}

void Get_Reply() {
       while (!Serial1.available());
       devnull = Serial1.read();
       while (!Serial1.available());
       returnLength = Serial1.read() - 1;
       
       for (unsigned int i=0;i< returnLength;i=i){
         //Serial.print("2"); 
         if (Serial1.available()) {
            //Serial.print("\n\ri is: ");Serial.print(i);Serial.print(" ");
            Serial.print(Serial1.read(),HEX); //Display the Serial Number in HEX
            i++;
          }
        }
}
/*
   if (Serial.available()){
    command = Serial.read();
    switch ( command ){
    case '1':
        Serial.println("\n\rRead Card Make...");
        Serial1.write(0xAB);Serial1.write(0x02);Serial1.write(0x01);
        break;
    case '2':
        Serial.println("\n\rRead Card Serial...");
        Serial1.write(0xAB);Serial1.write(0x02);Serial1.write(0x02);
        break;
    case '3':
        Serial.println("\n\rRead Card DATA...");
        Serial1.write(0xAB);
        Serial1.write(0x0A);
        Serial1.write(0x03);
        Serial1.write(0x04);
        Serial1.write(0x00,HEX);
        Serial1.write(0xFF);
        Serial1.write(0xFF);
        Serial1.write(0xFF);
        Serial1.write(0xFF);
        Serial1.write(0xFF);
        Serial1.write(0xFF);
        break;
    }
  }
  */
