/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : AF12x16.h
    Date                : 2011/06/18
    Font size in bytes  : 0x0E84, 3716
    Font width          : 12
    Font height         : 16
    Font first char     : 0x00
    Font last char      : 0xFF
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef AF12x16_H
#define AF12x16_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define AF12x16_WIDTH 12
#define AF12x16_HEIGHT 16

uint8_t __attribute__ ((progmem)) AF12x16[] = {
    0x0E, 0x84, 0x0C, 0x10, 0x01, 0x00, 0xFF,
    0x05, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x08, 0x09, 0x08, 0x09, 0x08, 0x09, 0x09, 0x09, 0x0B, 
    0x03, 0x02, 0x05, 0x06, 0x07, 0x07, 0x06, 0x07, 0x07, 0x05, 0x0B, 0x06, 0x04, 0x04, 0x04, 0x04, 
    0x02, 0x01, 0x03, 0x08, 0x07, 0x05, 0x08, 0x01, 0x03, 0x03, 0x07, 0x07, 0x04, 0x06, 0x02, 0x09, 
    0x06, 0x05, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x04, 0x05, 0x06, 0x05, 0x06, 
    0x08, 0x09, 0x07, 0x07, 0x07, 0x07, 0x07, 0x08, 0x09, 0x05, 0x08, 0x08, 0x07, 0x09, 0x09, 0x07, 
    0x07, 0x07, 0x08, 0x07, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x07, 0x03, 0x08, 0x03, 0x07, 0x09, 
    0x02, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x07, 0x07, 0x05, 0x05, 0x07, 0x05, 0x09, 0x07, 0x07, 
    0x07, 0x07, 0x08, 0x07, 0x07, 0x07, 0x09, 0x09, 0x07, 0x09, 0x07, 0x05, 0x01, 0x04, 0x07, 0x07, 
    0x05, 0x08, 0x06, 0x05, 0x09, 0x09, 0x07, 0x07, 0x07, 0x09, 0x09, 0x06, 0x05, 0x08, 0x06, 0x04, 
    0x09, 0x06, 0x06, 0x08, 0x09, 0x08, 0x08, 0x09, 0x04, 0x08, 0x04, 0x06, 0x08, 0x08, 0x09, 0x08, 
    0x08, 0x04, 0x04, 0x08, 0x08, 0x07, 0x05, 0x08, 0x06, 0x09, 0x04, 0x08, 0x04, 0x04, 0x09, 0x04, 
    0x06, 0x08, 0x08, 0x09, 0x08, 0x09, 0x09, 0x04, 0x05, 0x09, 0x04, 0x08, 0x09, 0x09, 0x09, 0x08, 
    0x04, 0x04, 0x06, 0x04, 0x07, 0x03, 0x09, 0x01, 0x08, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 
    0x04, 0x06, 0x06, 0x0E, 0x0E, 0x0F, 0x0F, 0x08, 0x08, 0x08, 0x07, 0x07, 0x03, 0x0A, 0x08, 0x08, 
    0x08, 0x07, 0x08, 0x06, 0x08, 0x05, 0x06, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x07, 0x07, 
    0x06, 0x07, 0x04, 0x04, 0x08, 0x06, 0x06, 0x08, 0x07, 0x08, 0x05, 0x08, 0x07, 0x04, 0x09, 0x04, 
    
    0x00, 0x00, 0x00, 0x00, 0xF8, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x0A, 0x00, 0x05, 0x00, 
    0xF5, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0xFA, 0x03, 0x02, 0x04, 
    0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xF8, 0x53, 0x00, 0x54, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x04, 0x80, 0x24, 0x00, 0x03, 0x00, 0x04, 0x10, 0x04, 0x80, 0x04, 0x10, 0x03, 0x00, 0x04, 
    0x10, 0x04, 0x84, 0x04, 0x10, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x80, 0x04, 0x80, 0x24, 
    0x00, 0x05, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00, 0x80, 0x1C, 0x40, 0x22, 0x40, 0x41, 0x40, 0x41, 
    0x80, 0x48, 0x80, 0x41, 0x80, 0x42, 0x80, 0x24, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x80, 0x04, 
    0x80, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00, 0x80, 0x1C, 0x40, 0x22, 0x40, 0x41, 
    0x40, 0x41, 0x80, 0x40, 0x80, 0x41, 0x80, 0x42, 0x80, 0x24, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 
    0x90, 0x04, 0x80, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00, 0x80, 0x1C, 0x40, 0x22, 
    0x48, 0x41, 0x40, 0x41, 0x80, 0x40, 0x80, 0x41, 0x80, 0x42, 0x80, 0x24, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 
    0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x20, 0x04, 0x08, 0x03, 0x20, 0x04, 0x00, 0x04, 0x00, 0x03, 
    0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x06, 0x00, 0x05, 0x80, 0x04, 
    0x80, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x01, 0x80, 0x03, 0x00, 0x01, 0x30, 0x00, 0xC0, 0x1F, 
    0x30, 0x00, 0xE0, 0x00, 0x40, 0x1F, 0x40, 0x00, 0x30, 0x00, 0x30, 0x00, 0xE0, 0x00, 0x40, 0x1F, 
    0x30, 0x00, 0x40, 0x00, 0x30, 0x00, 0x20, 0x00, 0xF0, 0x00, 0xE0, 0x1F, 0x60, 0x00, 0x90, 0x00, 
    0x90, 0x00, 0x40, 0x00, 0x00, 0x0E, 0x80, 0x11, 0x50, 0x10, 0x20, 0x0C, 0x40, 0x10, 0x80, 0x11, 
    0x00, 0x0E, 0xC0, 0x10, 0x20, 0x09, 0x10, 0x05, 0x10, 0x03, 0x20, 0x01, 0x80, 0x00, 0x30, 0x00, 
    0xC0, 0x00, 0x00, 0x03, 0x00, 0x1C, 0x00, 0x03, 0xC0, 0x00, 0x30, 0x00, 0x00, 0x18, 0x00, 0x06, 
    0x80, 0x01, 0x70, 0x00, 0x80, 0x01, 0x00, 0x06, 0x00, 0x18, 0x60, 0x00, 0x90, 0x00, 0x90, 0x00, 
    0xE0, 0x07, 0x00, 0x18, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x06, 
    0x10, 0x05, 0x80, 0x04, 0x80, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x04, 0x80, 0x05, 0x40, 0x06, 
    0x40, 0x04, 0x80, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x80, 0x03, 0x40, 0x03, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x02, 0xC0, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0xE0, 0x04, 0x90, 0x04, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x05, 0x78, 0x00, 0x00, 0x00, 
    0x78, 0x00, 0x00, 0x02, 0x40, 0x1E, 0xC0, 0x03, 0x78, 0x02, 0x40, 0x1E, 0xC0, 0x03, 0x78, 0x02, 
    0x40, 0x00, 0xC0, 0x11, 0x20, 0x22, 0x20, 0x22, 0x30, 0x62, 0x20, 0x22, 0x20, 0x22, 0x40, 0x1C, 
    0x06, 0x06, 0x80, 0x01, 0x60, 0x00, 0x18, 0x00, 0x06, 0x06, 0x00, 0x0E, 0x70, 0x11, 0x88, 0x10, 
    0x08, 0x11, 0x08, 0x12, 0x10, 0x0C, 0x00, 0x0C, 0x00, 0x12, 0x78, 0x00, 0xC0, 0x1F, 0x30, 0x60, 
    0x08, 0x80, 0x08, 0x80, 0x30, 0x60, 0xC0, 0x1F, 0x80, 0x00, 0xA0, 0x02, 0xE0, 0x03, 0xC0, 0x01, 
    0xE0, 0x03, 0xA0, 0x02, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xF0, 0x07, 0x80, 0x00, 
    0x80, 0x00, 0x80, 0x00, 0x00, 0x20, 0x00, 0x38, 0x00, 0x18, 0x00, 0x08, 0x00, 0x01, 0x00, 0x01, 
    0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x18, 0x00, 0x18, 0x00, 0x08, 0x00, 0x04, 
    0x00, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0xF0, 0x0F, 
    0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0xF0, 0x0F, 0x10, 0x10, 0x10, 0x10, 0xF8, 0x1F, 
    0x00, 0x10, 0x00, 0x10, 0x10, 0x18, 0x08, 0x14, 0x08, 0x12, 0x08, 0x11, 0x88, 0x10, 0x70, 0x10, 
    0x10, 0x08, 0x08, 0x10, 0x88, 0x10, 0x88, 0x10, 0x88, 0x10, 0x70, 0x0F, 0x00, 0x03, 0x80, 0x02, 
    0x60, 0x02, 0x10, 0x12, 0xF8, 0x1F, 0x00, 0x12, 0xF8, 0x08, 0x88, 0x10, 0x88, 0x10, 0x88, 0x10, 
    0x88, 0x10, 0x08, 0x0F, 0xE0, 0x0F, 0x10, 0x11, 0x88, 0x10, 0x88, 0x10, 0x88, 0x10, 0x00, 0x0F, 
    0x18, 0x00, 0x08, 0x18, 0x08, 0x06, 0x88, 0x01, 0x68, 0x00, 0x18, 0x00, 0x70, 0x0F, 0x88, 0x10, 
    0x88, 0x10, 0x88, 0x10, 0x88, 0x10, 0x70, 0x0F, 0xF0, 0x00, 0x08, 0x11, 0x08, 0x11, 0x08, 0x11, 
    0x88, 0x08, 0xF0, 0x07, 0xC0, 0x18, 0xC0, 0x18, 0x00, 0x20, 0xC0, 0x38, 0xC0, 0x18, 0x00, 0x08, 
    0x00, 0x01, 0x80, 0x02, 0x40, 0x04, 0x20, 0x08, 0x10, 0x10, 0x80, 0x02, 0x80, 0x02, 0x80, 0x02, 
    0x80, 0x02, 0x80, 0x02, 0x80, 0x02, 0x10, 0x10, 0x20, 0x08, 0x40, 0x04, 0x80, 0x02, 0x00, 0x01, 
    0x10, 0x00, 0x08, 0x00, 0x08, 0x16, 0x08, 0x01, 0x88, 0x00, 0x70, 0x00, 0xE0, 0x0F, 0x10, 0x10, 
    0x88, 0x23, 0x48, 0x24, 0x48, 0x24, 0xC8, 0x23, 0x10, 0x24, 0xE0, 0x03, 0x00, 0x10, 0x00, 0x1C, 
    0x88, 0x13, 0x68, 0x02, 0x18, 0x02, 0x60, 0x02, 0x80, 0x13, 0x00, 0x1C, 0x00, 0x10, 0x08, 0x10, 
    0xF8, 0x1F, 0x88, 0x10, 0x88, 0x10, 0x88, 0x10, 0x88, 0x10, 0x70, 0x0F, 0xE0, 0x07, 0x10, 0x08, 
    0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x10, 0x10, 0x78, 0x08, 0x08, 0x10, 0xF8, 0x1F, 0x08, 0x10, 
    0x08, 0x10, 0x08, 0x10, 0x10, 0x08, 0xE0, 0x07, 0x08, 0x10, 0xF8, 0x1F, 0x88, 0x10, 0x88, 0x10, 
    0xC8, 0x11, 0x08, 0x10, 0x18, 0x18, 0x08, 0x10, 0xF8, 0x1F, 0x88, 0x10, 0x88, 0x10, 0xC8, 0x01, 
    0x08, 0x00, 0x18, 0x00, 0xE0, 0x07, 0x10, 0x08, 0x08, 0x10, 0x08, 0x10, 0x08, 0x11, 0x10, 0x11, 
    0x78, 0x0F, 0x00, 0x01, 0x08, 0x10, 0xF8, 0x1F, 0x88, 0x10, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 
    0x88, 0x10, 0xF8, 0x1F, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0xF8, 0x1F, 0x08, 0x10, 0x08, 0x10, 
    0x00, 0x0C, 0x00, 0x10, 0x00, 0x10, 0x08, 0x10, 0x08, 0x10, 0xF8, 0x0F, 0x08, 0x00, 0x08, 0x00, 
    0x08, 0x10, 0xF8, 0x1F, 0x08, 0x11, 0x80, 0x01, 0x68, 0x02, 0x18, 0x04, 0x08, 0x18, 0x00, 0x10, 
    0x08, 0x10, 0xF8, 0x1F, 0x08, 0x10, 0x08, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x18, 0x08, 0x10, 
    0xF8, 0x1F, 0x60, 0x10, 0x80, 0x01, 0x00, 0x06, 0x80, 0x01, 0x60, 0x10, 0xF8, 0x1F, 0x08, 0x10, 
    0x08, 0x10, 0xF8, 0x1F, 0x20, 0x10, 0xC0, 0x10, 0x00, 0x01, 0x08, 0x06, 0x08, 0x08, 0xF8, 0x1F, 
    0x08, 0x00, 0xE0, 0x07, 0x10, 0x08, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x10, 0x08, 0xE0, 0x07, 
    0x08, 0x10, 0xF8, 0x1F, 0x08, 0x11, 0x08, 0x11, 0x08, 0x01, 0x08, 0x01, 0xF0, 0x00, 0xE0, 0x07, 
    0x10, 0x48, 0x08, 0x50, 0x08, 0x30, 0x08, 0x30, 0x10, 0x48, 0xE0, 0x47, 0x08, 0x10, 0xF8, 0x1F, 
    0x08, 0x11, 0x08, 0x01, 0x08, 0x03, 0x08, 0x05, 0xF0, 0x18, 0x00, 0x10, 0x70, 0x1C, 0x88, 0x08, 
    0x88, 0x10, 0x88, 0x10, 0x08, 0x11, 0x10, 0x11, 0x38, 0x0E, 0x18, 0x00, 0x08, 0x00, 0x08, 0x10, 
    0x08, 0x10, 0xF8, 0x1F, 0x08, 0x10, 0x08, 0x10, 0x08, 0x00, 0x18, 0x00, 0x08, 0x00, 0xF8, 0x0F, 
    0x08, 0x08, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x08, 0x08, 0xF8, 0x0F, 0x08, 0x00, 0x08, 0x00, 
    0x38, 0x00, 0xC8, 0x01, 0x00, 0x06, 0x00, 0x18, 0x00, 0x06, 0xC8, 0x01, 0x38, 0x00, 0x08, 0x00, 
    0x78, 0x00, 0x88, 0x03, 0x00, 0x1C, 0x80, 0x03, 0x60, 0x00, 0x80, 0x03, 0x00, 0x1C, 0x88, 0x03, 
    0x78, 0x00, 0x08, 0x10, 0x18, 0x18, 0x28, 0x14, 0x40, 0x02, 0x80, 0x01, 0x40, 0x02, 0x28, 0x14, 
    0x18, 0x18, 0x08, 0x10, 0x08, 0x00, 0x18, 0x00, 0x68, 0x10, 0x80, 0x10, 0x00, 0x1F, 0x80, 0x10, 
    0x68, 0x10, 0x18, 0x00, 0x08, 0x00, 0x18, 0x18, 0x08, 0x14, 0x08, 0x12, 0x88, 0x11, 0x48, 0x10, 
    0x28, 0x10, 0x18, 0x18, 0xFE, 0x3F, 0x02, 0x20, 0x02, 0x20, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 
    0x80, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x02, 0x20, 0x02, 0x20, 0xFE, 0x3F, 
    0x40, 0x00, 0x20, 0x00, 0x10, 0x00, 0x08, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x40, 
    0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 
    0x08, 0x00, 0x10, 0x00, 0x00, 0x0E, 0x40, 0x11, 0x40, 0x11, 0x40, 0x11, 0x40, 0x11, 0x80, 0x0F, 
    0x00, 0x10, 0x08, 0x10, 0xF8, 0x1F, 0x80, 0x08, 0x40, 0x10, 0x40, 0x10, 0x80, 0x08, 0x00, 0x07, 
    0x00, 0x07, 0x80, 0x08, 0x40, 0x10, 0x40, 0x10, 0x40, 0x10, 0x80, 0x08, 0xC0, 0x08, 0x00, 0x07, 
    0x80, 0x08, 0x40, 0x10, 0x40, 0x10, 0x88, 0x08, 0xF8, 0x1F, 0x00, 0x10, 0x00, 0x07, 0x80, 0x0A, 
    0x40, 0x12, 0x40, 0x12, 0x40, 0x12, 0x80, 0x0A, 0x00, 0x0B, 0x80, 0x10, 0xF0, 0x1F, 0x88, 0x10, 
    0x88, 0x10, 0x08, 0x00, 0x10, 0x00, 0x00, 0x63, 0x80, 0x84, 0x40, 0x88, 0x40, 0x88, 0x80, 0x84, 
    0xC0, 0x7F, 0x40, 0x00, 0x08, 0x10, 0xF8, 0x1F, 0x80, 0x10, 0x40, 0x00, 0x40, 0x10, 0x80, 0x1F, 
    0x00, 0x10, 0x40, 0x10, 0x40, 0x10, 0xC8, 0x1F, 0x00, 0x10, 0x00, 0x10, 0x00, 0x40, 0x00, 0x80, 
    0x40, 0x80, 0x40, 0x80, 0xC8, 0x7F, 0x08, 0x10, 0xF8, 0x1F, 0x08, 0x12, 0x08, 0x03, 0xC0, 0x14, 
    0x40, 0x18, 0x40, 0x10, 0x08, 0x10, 0x08, 0x10, 0xF8, 0x1F, 0x00, 0x10, 0x00, 0x10, 0x40, 0x10, 
    0xC0, 0x1F, 0x80, 0x10, 0x40, 0x00, 0xC0, 0x1F, 0x80, 0x10, 0x40, 0x00, 0xC0, 0x1F, 0x00, 0x10, 
    0x40, 0x10, 0xC0, 0x1F, 0x80, 0x10, 0x40, 0x00, 0x40, 0x10, 0x80, 0x1F, 0x00, 0x10, 0x00, 0x07, 
    0x80, 0x08, 0x40, 0x10, 0x40, 0x10, 0x40, 0x10, 0x80, 0x08, 0x00, 0x07, 0x40, 0x80, 0xC0, 0xFF, 
    0x80, 0x88, 0x40, 0x90, 0x40, 0x10, 0x80, 0x08, 0x00, 0x07, 0x00, 0x07, 0x80, 0x08, 0x40, 0x10, 
    0x40, 0x90, 0x80, 0x88, 0xC0, 0xFF, 0x40, 0x80, 0x40, 0x10, 0x40, 0x10, 0xC0, 0x1F, 0x80, 0x10, 
    0x40, 0x10, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0x80, 0x09, 0x40, 0x12, 0x40, 0x12, 0x40, 0x12, 
    0x40, 0x12, 0x40, 0x12, 0x80, 0x0C, 0x40, 0x00, 0x40, 0x00, 0xF0, 0x0F, 0x40, 0x10, 0x40, 0x10, 
    0x40, 0x10, 0x00, 0x08, 0x40, 0x00, 0xC0, 0x0F, 0x00, 0x10, 0x00, 0x10, 0x40, 0x08, 0xC0, 0x1F, 
    0x00, 0x10, 0x40, 0x00, 0xC0, 0x00, 0x40, 0x03, 0x00, 0x0C, 0x00, 0x10, 0x00, 0x0C, 0x40, 0x03, 
    0xC0, 0x00, 0x40, 0x00, 0x40, 0x00, 0xC0, 0x0F, 0x40, 0x18, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x07, 
    0x40, 0x18, 0xC0, 0x07, 0x40, 0x00, 0x40, 0x10, 0xC0, 0x18, 0x40, 0x15, 0x00, 0x02, 0x40, 0x15, 
    0xC0, 0x18, 0x40, 0x10, 0x40, 0x00, 0xC0, 0x80, 0x40, 0x83, 0x00, 0x4C, 0x00, 0x30, 0x00, 0x0C, 
    0x40, 0x03, 0xC0, 0x00, 0x40, 0x00, 0xC0, 0x10, 0x40, 0x18, 0x40, 0x14, 0x40, 0x12, 0x40, 0x11, 
    0xC0, 0x10, 0x40, 0x18, 0x00, 0x02, 0x00, 0x02, 0xF0, 0x7D, 0x08, 0x80, 0x08, 0x80, 0xF8, 0xFF, 
    0x08, 0x80, 0x08, 0x80, 0xF0, 0x7D, 0x00, 0x02, 0x30, 0x00, 0x08, 0x00, 0x08, 0x00, 0x10, 0x00, 
    0x20, 0x00, 0x20, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x80, 0x22, 0x48, 0x41, 0x40, 0x41, 
    0xC0, 0x42, 0x00, 0x44, 0x00, 0x04, 0x80, 0x04, 0x48, 0x05, 0x40, 0x06, 0x80, 0x03, 0x00, 0x03, 
    0x80, 0x04, 0x00, 0x14, 0x00, 0x44, 0x00, 0x14, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x20, 0x00, 0x38, 0x00, 0x18, 0x00, 0x08, 0x00, 0x04, 0x88, 0x04, 0x40, 0x05, 
    0x48, 0x06, 0x80, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x38, 0x00, 0x18, 0x00, 0x08, 0x00, 0x20, 
    0x00, 0x38, 0x00, 0x18, 0x00, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 
    0x00, 0x18, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 
    0xF8, 0x3F, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x08, 0x20, 0x08, 0xF8, 0x3F, 
    0x20, 0x08, 0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 
    0x10, 0x00, 0x30, 0x0C, 0x48, 0x02, 0x30, 0x01, 0x80, 0x0C, 0x40, 0x12, 0x20, 0x0C, 0x18, 0x0C, 
    0x00, 0x12, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 
    0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x02, 0x40, 0x04, 
    0x20, 0x08, 0x00, 0x04, 0x60, 0x04, 0x50, 0x04, 0x90, 0x04, 0x08, 0x03, 0x80, 0x1C, 0x40, 0x22, 
    0x40, 0x41, 0x40, 0x45, 0x80, 0x50, 0x80, 0x44, 0x80, 0x40, 0x80, 0x20, 0x00, 0x20, 0x00, 0x20, 
    0x00, 0x10, 0x20, 0x10, 0x08, 0x08, 0x20, 0x07, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 
    0x00, 0x00, 0x00, 0x03, 0x80, 0x04, 0x00, 0x04, 0x00, 0x04, 0x64, 0x04, 0x52, 0x04, 0x92, 0x04, 
    0x09, 0x03, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x30, 0x00, 0x38, 0x00, 0x08, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0x00, 0x38, 0x00, 0x18, 0x00, 0x08, 0x00, 0x20, 0x00, 0x30, 0x00, 0x38, 0x00, 
    0x08, 0x00, 0x20, 0x00, 0x30, 0x00, 0x38, 0x00, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x38, 0x00, 
    0x18, 0x00, 0x08, 0x00, 0x20, 0x00, 0x38, 0x00, 0x18, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x04, 0x00, 0x0F, 0x80, 0x14, 0x40, 0x32, 0x80, 0x29, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 
    0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 
    0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 
    0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x38, 0x00, 0x08, 0x00, 0x38, 0x00, 
    0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x20, 0x08, 0x40, 0x04, 0x80, 0x02, 0x00, 0x01, 0x00, 0x38, 0x00, 0x44, 0x00, 0x40, 
    0x00, 0x40, 0x00, 0x48, 0x00, 0x54, 0x00, 0x54, 0x00, 0x34, 0x00, 0x04, 0x00, 0x04, 0x00, 0x15, 
    0x80, 0x44, 0x80, 0x14, 0x00, 0x05, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00, 0x80, 0x1C, 0x40, 0x22, 
    0x40, 0x41, 0x40, 0x45, 0x80, 0x50, 0x80, 0x45, 0x80, 0x42, 0x80, 0x24, 0x00, 0x00, 0x08, 0x00, 
    0x10, 0x04, 0x20, 0x04, 0x40, 0x02, 0x80, 0x01, 0xF8, 0x03, 0x00, 0x04, 0x00, 0x38, 0x00, 0x44, 
    0x00, 0x40, 0x00, 0xC0, 0x00, 0x48, 0x00, 0xD4, 0x00, 0x54, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 
    0x80, 0x03, 0x40, 0x03, 0x00, 0x04, 0x14, 0x04, 0x8A, 0x04, 0x0A, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x70, 0x11, 0x88, 0x1F, 0x08, 0x11, 0x08, 0x11, 0x30, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 
    0x08, 0x01, 0xF0, 0x00, 0x90, 0x00, 0x90, 0x00, 0xF0, 0x00, 0x08, 0x01, 0x00, 0x00, 0x08, 0x00, 
    0x10, 0x00, 0x20, 0x0C, 0x40, 0x0A, 0x80, 0x09, 0xF8, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0xC0, 0x30, 0x30, 0x21, 0x28, 0x22, 0x48, 0x24, 0x88, 0x28, 
    0x08, 0x19, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 
    0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 0xE4, 0x09, 0x14, 0x0A, 0x14, 0x0A, 0x24, 0x09, 0x08, 0x04, 
    0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00, 0x00, 0x40, 0x00, 0xA0, 0x00, 
    0x10, 0x01, 0x48, 0x02, 0xA0, 0x00, 0x10, 0x01, 0x08, 0x02, 0x18, 0x00, 0x12, 0x00, 0x09, 0x00, 
    0x0C, 0x00, 0x1A, 0x00, 0x13, 0x00, 0x09, 0x00, 0x0C, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x08, 0x04, 
    0xF4, 0x0B, 0x94, 0x08, 0x94, 0x08, 0x64, 0x0B, 0x08, 0x04, 0xF0, 0x03, 0x06, 0x00, 0x14, 0x00, 
    0x0A, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x48, 0x00, 0x48, 0x00, 0x30, 0x00, 
    0x00, 0x00, 0x80, 0x10, 0x80, 0x10, 0x80, 0x10, 0xF0, 0x17, 0x80, 0x10, 0x80, 0x10, 0x80, 0x10, 
    0x00, 0x00, 0x0A, 0x00, 0x05, 0x00, 0x15, 0x00, 0x24, 0x0C, 0x40, 0x0A, 0x80, 0x09, 0xF8, 0x0E, 
    0x00, 0x00, 0x0A, 0x00, 0x05, 0x00, 0x15, 0x04, 0x24, 0x04, 0x40, 0x02, 0x80, 0x01, 0xF8, 0x03, 
    0x00, 0x04, 0x04, 0x00, 0x02, 0x00, 0x0A, 0x00, 0x12, 0x00, 0x21, 0x0C, 0x40, 0x0A, 0x80, 0x09, 
    0xFC, 0x0E, 0x00, 0x00, 0x00, 0x38, 0x80, 0x44, 0x60, 0x40, 0x50, 0x40, 0x50, 0x48, 0x00, 0x54, 
    0x00, 0x54, 0x00, 0x34, 0x00, 0x00, 0xF0, 0x00, 0xF8, 0x01, 0x18, 0x01, 0x18, 0x10, 0xF8, 0x1F, 
    0x18, 0x00, 0xF8, 0x1F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x00, 0xA0, 0x00, 0x40, 0x04, 0x00, 0x02, 0x00, 0x0A, 0x00, 0x12, 0x04, 
    0x21, 0x04, 0x40, 0x02, 0x80, 0x01, 0xF8, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x04, 
    0x90, 0x04, 0x00, 0x00, 0x08, 0x02, 0x10, 0x01, 0xA0, 0x00, 0x48, 0x02, 0x10, 0x01, 0xA0, 0x00, 
    0x40, 0x00, 0x00, 0x00, 0x10, 0x08, 0xF8, 0x05, 0x00, 0x02, 0x00, 0x0D, 0x80, 0x0A, 0x40, 0x09, 
    0xA0, 0x1F, 0x10, 0x08, 0x00, 0x00, 0x10, 0x08, 0xF8, 0x05, 0x00, 0x02, 0x00, 0x01, 0x80, 0x11, 
    0xC0, 0x18, 0xA0, 0x14, 0x10, 0x13, 0x00, 0x00, 0x90, 0x08, 0x08, 0x05, 0x28, 0x03, 0xD0, 0x0D, 
    0x80, 0x0A, 0x40, 0x09, 0xA0, 0x1F, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 
    0x08, 0x01, 0x08, 0x16, 0x08, 0x00, 0x30, 0x00, 0x00, 0x04, 0x00, 0x24, 0x80, 0x04, 0x00, 0x23, 
    0x00, 0x05, 0x80, 0x06, 0x80, 0x02, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0xFA, 0x07, 
    0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x05, 0x00, 0xF5, 0x07, 0x00, 0x00, 0x00, 0x40, 
    0x50, 0x40, 0x28, 0x23, 0xA8, 0x24, 0x80, 0x14, 0x00, 0x0F, 0x00, 0xA0, 0xF8, 0x57, 0x00, 0x50, 
    0x00, 0x1E, 0x28, 0x21, 0x14, 0x20, 0x14, 0x20, 0x00, 0x20, 0x00, 0x26, 0x00, 0x15, 0x80, 0x0C, 
    0x80, 0x00, 0xF8, 0x07, 0x00, 0x03, 0x80, 0x04, 0x00, 0x04, 0x00, 0x24, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x04, 0x00, 0x03, 0x00, 0x00, 0x88, 0x03, 0x40, 0x04, 0x48, 0x04, 0x80, 0x04, 0x00, 0x03, 
    0x00, 0x03, 0x80, 0x04, 0x00, 0x04, 0x20, 0x04, 0x00, 0x04, 0x20, 0x04, 0x00, 0x04, 0x00, 0x03, 
    0x00, 0x03, 0x80, 0x04, 0x00, 0x04, 0x20, 0x04, 0x08, 0x04, 0x20, 0x04, 0x00, 0x04, 0x00, 0x03, 
    0x80, 0x1C, 0x40, 0x22, 0x40, 0x41, 0x40, 0x41, 0x80, 0x48, 0x80, 0x40, 0x80, 0x40, 0x80, 0x20, 
    0x80, 0x1C, 0x40, 0x22, 0x40, 0x41, 0x40, 0x41, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x20, 
    0x80, 0x1C, 0x40, 0x22, 0x48, 0x41, 0x40, 0x41, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x20, 
    0x00, 0x04, 0x40, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x04, 0x48, 0x04, 0x80, 0x04, 0x00, 0x03, 
    0x00, 0x20, 0x00, 0x20, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0x00, 0x07, 0x00, 0x20, 0x00, 0x20, 
    0x00, 0x10, 0x00, 0x10, 0x20, 0x08, 0x00, 0x07, 0x00, 0x1C, 0x00, 0x22, 0x00, 0x40, 0x00, 0x40, 
    0x00, 0x40, 0x00, 0x40, 0x00, 0x23, 0x00, 0x1C, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 
    0x00, 0x04, 0x00, 0x03, 0x00, 0x1C, 0x00, 0x22, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 
    0x00, 0x23, 0x00, 0x1C, 0x00, 0x04, 0x20, 0x04, 0x08, 0x03, 0x20, 0x04, 0x00, 0x04, 0x00, 0x03, 
    0x00, 0x1C, 0x00, 0x22, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x23, 0x00, 0x1C, 
    0x00, 0x04, 0x00, 0x06, 0x00, 0x05, 0x80, 0x04, 0x80, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x1C, 
    0x00, 0x22, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x23, 0x00, 0x1C, 0x00, 0x04, 
    0x00, 0x06, 0x10, 0x05, 0x80, 0x04, 0x80, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x00, 0x20, 0x08, 
    0x40, 0x04, 0x80, 0x02, 0x00, 0x01, 0x80, 0x02, 0x40, 0x04, 0x20, 0x08, 0x00, 0x04, 0x00, 0x04, 
    0xF8, 0x07, 0x00, 0x06, 0x00, 0x05, 0x80, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 
    0xF8, 0x07, 0x00, 0x06, 0x00, 0x05, 0x90, 0x04, 0x80, 0x04, 0x00, 0x03, 0xC0, 0x1C, 0x20, 0x23, 
    0x20, 0x41, 0x00, 0x41, 0x80, 0x40, 0x00, 0x40, 0x00, 0x20, 0xC0, 0x1C, 0x24, 0x23, 0x20, 0x41, 
    0x00, 0x41, 0x80, 0x40, 0x00, 0x40, 0x00, 0x20, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 
    0x80, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x80, 0x04, 0x48, 0x05, 0x40, 0x06, 
    0x80, 0x03, 0x00, 0x1C, 0x00, 0x22, 0x00, 0x40, 0x00, 0x40, 0x10, 0x43, 0x80, 0x44, 0x90, 0x24, 
    0x00, 0x1F, 0x00, 0x03, 0x80, 0x04, 0x00, 0x04, 0x00, 0x04, 0x60, 0x04, 0x50, 0x04, 0x90, 0x04, 
    0x08, 0x03, 0x00, 0x00, 0x00, 0x0E, 0x40, 0x11, 0x48, 0x11, 0x50, 0x11, 0x40, 0x11, 0x80, 0x0F, 
    0x00, 0x10, 0x00, 0x0E, 0x00, 0x11, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x08, 0xF8, 0x07, 
    0x00, 0x00, 0x00, 0x0E, 0x40, 0x11, 0x50, 0x11, 0x48, 0x11, 0x50, 0x11, 0x80, 0x0F, 0x00, 0x10, 
    0x00, 0xF8, 0x00, 0x04, 0x00, 0x07, 0x80, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x1C, 0x00, 0x22, 
    0x00, 0x40, 0x40, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x21, 0x00, 0x1E, 0x80, 0x03, 0x40, 0x04, 
    0x40, 0x04, 0x80, 0x04, 0x00, 0x03, 0x00, 0x40, 0x00, 0x40, 0x00, 0x23, 0x80, 0x24, 0x80, 0x14, 
    0x00, 0x0F, 0x00, 0x00, 0x00, 0x01, 0x80, 0x02, 0x80, 0x02, 0x60, 0x02, 0x80, 0x01, 0x00, 0x02, 
    0x00, 0x04, 0x00, 0x00, 0x14, 0x01, 0x8A, 0x02, 0x8A, 0x02, 0x68, 0x02, 0x80, 0x01, 0x00, 0x02, 
    0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x84, 0x02, 0x80, 0x02, 0x64, 0x02, 0x80, 0x01, 0x00, 0x02, 
    0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x80, 0x0A, 0x50, 0x12, 0x48, 0x12, 0x50, 0x12, 0x80, 0x0A, 
    0x00, 0x0B, 0x00, 0x00, 0x00, 0x07, 0x88, 0x0A, 0x40, 0x12, 0x40, 0x12, 0x40, 0x12, 0x88, 0x0A, 
    0x00, 0x0B, 0x00, 0x1E, 0x00, 0x21, 0x00, 0xA0, 0x00, 0x20, 0x00, 0xA0, 0x00, 0x26, 0x00, 0x15, 
    0x80, 0x0C, 0x80, 0x00, 0x00, 0x1E, 0x00, 0x21, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x26, 
    0x00, 0x15, 0x80, 0x0C, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0x50, 0x10, 0xC8, 0x1F, 
    0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x48, 0x10, 0x40, 0x10, 0xC0, 0x1F, 0x08, 0x10, 
    0x00, 0x10, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x80, 0x06, 0x80, 0x06, 0x80, 0x05, 0x00, 0x00, 
    0x00, 0x1C, 0x80, 0x22, 0x40, 0x41, 0x40, 0x41, 0xC0, 0x42, 0x00, 0x44, 0x00, 0x04, 0x00, 0x04, 
    0x90, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x07, 
    0x80, 0x08, 0x50, 0x10, 0x48, 0x10, 0x50, 0x10, 0x80, 0x08, 0x00, 0x07, 0x00, 0x04, 0x80, 0x05, 
    0x48, 0x06, 0x40, 0x04, 0x80, 0x04, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x80, 0x06, 
    0x90, 0x06, 0x80, 0x05, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x48, 0x02, 0x40, 0x00, 
    0x40, 0x00, 0x40, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x02, 0x00, 0x03, 0x80, 0x04, 0x80, 0x04, 
    0x00, 0x03, 0x00, 0x00, 0x40, 0x00, 0xC0, 0x0F, 0x08, 0x10, 0x10, 0x10, 0x40, 0x08, 0xC0, 0x1F, 
    0x00, 0x10, 0x00, 0x04, 0x64, 0x04, 0x52, 0x04, 0x92, 0x04, 0x09, 0x03, 0x00, 0x00, 0x40, 0x00, 
    0xC0, 0x0F, 0x10, 0x10, 0x08, 0x10, 0x50, 0x08, 0xC0, 0x1F, 0x00, 0x10, 0x00, 0x00, 0x08, 0xA0, 
    0x10, 0x50, 0x20, 0x5C, 0x40, 0x4A, 0x80, 0x09, 0xF8, 0x0E, 0x00, 0x04, 0x00, 0x14, 0x80, 0x44, 
    0x00, 0x13, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x80, 0x05, 0x50, 0x06, 0x20, 0x03, 0xC0, 0x04, 
    0x80, 0x04, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00
};

#endif

