//-----------------------------------------------------------------------------
// Copyright:      RAD Electronic Co. LTD,
// Author:         Sh. Nourbakhsh Rad
// Remarks:        
// known Problems: none
// Version:        1.5.0
// Description:    GLCD's graphic founctions
//-----------------------------------------------------------------------------

#ifndef _GRAPHIC_H_
	#define _GRAPHIC_H_

	#include "TFT\ili9325.h"

	
	#define PutPixel(x, y, clr)											LCDPutPixel(x, y, clr, LCD_MODE_NORMAL)
	#define RectangleFill(x1, y1, x2, y2, clr)			LCDFillRect(x1, x2, y1, y2, clr, LCD_MODE_NORMAL)

	//			Line
	//			Rectangle

	#define Bevel(x1, y1, x2, y2, r, clr) 					RoundRectangle(x1, y1, x2, y2, r, 0, clr)
	#define BevelFill(x1, y1, x2, y2, r, clr)				RoundRectangle(x1, y1, x2, y2, r, 1, clr)
	#define Circle(x, y, r, clr)										Circle_Fill(x, y, r, 0, clr)
	#define CircleFill(x, y, r, clr)								Circle_Fill(x, y, r, 1, clr)

	#define VertLine(x, y, length, clr) 						LCDFillRect(x, y, x, y+length, clr, LCD_MODE_NORMAL)
	#define HoriLine(x, y, length, clr) 						LCDFillRect(x, y, x+length, y, clr, LCD_MODE_NORMAL)


	//******************* Function Prototypes
	extern void Line(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned short color);
	extern void Rectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned short color);
	extern void RoundRectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned int radius, unsigned char fill, unsigned short color);
	extern void Circle_Fill(unsigned int x, unsigned int y, unsigned int radius, unsigned char fill, unsigned short color);

#endif	//_GRAPHIC_H_
