//-----------------------------------------------------------------------------
// Copyright:      RAD Electronic Co. LTD,
// Author:         blue_screen_test_lib_3_12_2008 modefied by Sh. Nourbakhsh Rad
// Remarks:        
// known Problems: none
// Version:        1.5.0
// Description:    ILI9320 & ILI9325 TFT-LCD display driver
//-----------------------------------------------------------------------------

#include "ili9325.h"

//******************* Constants
unsigned char 							char_buf[24][4];

const unsigned char 				*font;
unsigned char 							FONT_BIT_WIDTH    = 9;
unsigned char 							FONT_BYTE_HEIGHT  = 2;
int 												FONT_SIZE         = 18;
unsigned char 							FONT_WIDTH        = 9;
unsigned char 							FONT_HEIGHT       = 16;
unsigned char 							char_gap          = 2;

unsigned short 							font_color;
unsigned short 							back_color;
int 												offsetx,offsety;
int 												LCD_margin_xl 		= 0;
int 												LCD_margin_xr 		= LCD_SIZE_X - 1;
int 												LCD_margin_yu 		= 0;
int 												LCD_margin_yl 		= LCD_SIZE_Y - 1;

unsigned char 							bold_on 					= 0;
unsigned char 							first_non_zero		= 0;
unsigned char 							last_non_zero			= 0;
unsigned char 							vary_width_on 		= 0;

unsigned char								LCDcolumn 				= 0;
unsigned char								LCDline 					= 0;
int 												LCDposx 					= 0;
int   											LCDposy 					= 0;
LCD_mode_t 									LCDmode 					= LCD_MODE_FULL;

unsigned int 								newX							= 0;
unsigned int 								newY							= 0;

//******************* Functions
void LCDSetFontColor(unsigned short color) 							//set text's color
{
	font_color = color;
} //*LCDSetFontColor

void LCDSetBackColor(unsigned short color) 							//set back color for LCD_MODE_FULL
{
	back_color = color;
} //*LCDSetBackColor

void LCDOutDat(unsigned short dat) 											//write data to LCD
{
	#if TFT_PORT_INTERFACE
		LCD_DB_DDR = 0xFF;
		
		sbi(LCD_RS_PRT,LCD_RS_BIT);
		cbi(LCD_CS_PRT,LCD_CS_BIT);

		cbi(LCD_WR_PRT,LCD_WR_BIT);
			LCD_DB_PRT = dat >> 8;
		sbi(LCD_WR_PRT,LCD_WR_BIT);

		cbi(LCD_WR_PRT,LCD_WR_BIT);
			LCD_DB_PRT = dat;
		sbi(LCD_WR_PRT,LCD_WR_BIT);

		sbi(LCD_CS_PRT,LCD_CS_BIT);
	#else
		*(volatile unsigned char *)(TFT_DATA_ADDR) = (dat >> 8);
		*(volatile unsigned char *)(TFT_DATA_ADDR) =  dat;
	#endif
} //*LCDOutDat

void LCDOutDat2(unsigned char dath,unsigned char datl) 	//write data to LCD
{
	#if TFT_PORT_INTERFACE
		LCD_DB_DDR = 0xFF;
		
		sbi(LCD_RS_PRT,LCD_RS_BIT);
		cbi(LCD_CS_PRT,LCD_CS_BIT);

		cbi(LCD_WR_PRT,LCD_WR_BIT);
			LCD_DB_PRT = dath;
		sbi(LCD_WR_PRT,LCD_WR_BIT);

		cbi(LCD_WR_PRT,LCD_WR_BIT);
			LCD_DB_PRT = datl;
		sbi(LCD_WR_PRT,LCD_WR_BIT);

		sbi(LCD_CS_PRT,LCD_CS_BIT);
	#else
		*(volatile unsigned char *)(TFT_DATA_ADDR) = dath;
		*(volatile unsigned char *)(TFT_DATA_ADDR) = datl;
	#endif	
} //*LCDOutDat2

void LCDOutIns(unsigned short ins) 											//write instruction to LCD
{
	#if TFT_PORT_INTERFACE
		LCD_DB_DDR = 0xFF;
		
		cbi(LCD_RS_PRT,LCD_RS_BIT);
		cbi(LCD_CS_PRT,LCD_CS_BIT);

		cbi(LCD_WR_PRT,LCD_WR_BIT);
			LCD_DB_PRT = ins >> 8;
		sbi(LCD_WR_PRT,LCD_WR_BIT);

		cbi(LCD_WR_PRT,LCD_WR_BIT);
			LCD_DB_PRT = ins;
		sbi(LCD_WR_PRT,LCD_WR_BIT);

		sbi(LCD_CS_PRT,LCD_CS_BIT);
	#else
		*(volatile unsigned char *)(TFT_CTRL_ADDR) = (ins >> 8);
		*(volatile unsigned char *)(TFT_CTRL_ADDR) =  ins;
	#endif
} //*LCDOutIns

unsigned short LCDInDat(void) 													//read data from LCD
{
	unsigned short dat = 0;
	
	#if TFT_PORT_INTERFACE
		LCD_DB_DDR = 0x00;
		
		sbi(LCD_RS_PRT,LCD_RS_BIT);
		cbi(LCD_CS_PRT,LCD_CS_BIT);

		cbi(LCD_RD_PRT,LCD_RD_BIT);
			_NOP();	_NOP();
			dat = LCD_DB_PIN;
		sbi(LCD_RD_PRT,LCD_RD_BIT);

		dat <<= 8;

		cbi(LCD_RD_PRT,LCD_RD_BIT);
			_NOP();	_NOP();
			dat |= LCD_DB_PIN;
		sbi(LCD_RD_PRT,LCD_RD_BIT);
		
		sbi(LCD_CS_PRT,LCD_CS_BIT);
	#else
		dat	= *(volatile unsigned char *)(TFT_DATA_ADDR);
		dat <<= 8;
		dat |= *(volatile unsigned char *)(TFT_DATA_ADDR);
	#endif
	
	return (dat);
} //*LCDInDat

unsigned short LCDInIns(void) 													//read data from LCD
{
	unsigned short ins = 0;    
	
	#if TFT_PORT_INTERFACE
		LCD_DB_DDR = 0x00;
		
		cbi(LCD_RS_PRT,LCD_RS_BIT);
		cbi(LCD_CS_PRT,LCD_CS_BIT);

		cbi(LCD_RD_PRT,LCD_RD_BIT);
			_NOP();	_NOP();
			ins = LCD_DB_PIN;
		sbi(LCD_RD_PRT,LCD_RD_BIT);

		ins <<= 8;

		cbi(LCD_RD_PRT,LCD_RD_BIT);
			_NOP();	_NOP();
			ins |= LCD_DB_PIN;
		sbi(LCD_RD_PRT,LCD_RD_BIT);
		
		sbi(LCD_CS_PRT,LCD_CS_BIT);
	#else
		ins  = *(volatile unsigned char *)(TFT_CTRL_ADDR);
		ins <<= 8;
		ins |= *(volatile unsigned char *)(TFT_CTRL_ADDR);
	#endif
	
	return (ins);
} //*LCDInIns

void LCDRst(void) 																			//pulse reset signal to LCD
{
	cbi(LCD_RST_PRT,LCD_RST_BIT);
	_delay_ms(1000);
	sbi(LCD_RST_PRT,LCD_RST_BIT);
	_delay_ms(200);
} //LCDRst

void LCDInit(void) 																			//initial LCD
{
	unsigned short driver_code;
	
	LCDPortInit();
	_delay_ms(100);
	LCDRst();
	_delay_ms(100);

	LCDOutIns(LCD_INS_START_OSC);
	driver_code = LCDInDat();
	
	if (driver_code == 0x9320)		//****  ILI9320
	{
		LCDOutIns(0x00E5);
		LCDOutDat(0x8000);                                  //set the internal vcore voltage
		LCDOutIns(LCD_INS_START_OSC);
		LCDOutDat(0x0001);                                  //start oscillator
		_delay_ms(100);
		LCDOutIns(LCD_INS_DRIV_OUT_CTRL);
		LCDOutDat(0x0100);                                  //set SS, SM
		LCDOutIns(LCD_INS_DRIV_WAV_CTRL);
		LCDOutDat(0x0700);                                  //set 1 line inversion
		LCDOutIns(LCD_INS_ENTRY_MOD);
		LCDOutDat(LCD_VAL_ENTRY_MOD);                       //set GRAM write direction, BGR=0
		LCDOutIns(LCD_INS_RESIZE_CTRL);
		LCDOutDat(0x0000);                                  //no resizing
		LCDOutIns(LCD_INS_DISP_CTRL2);
		LCDOutDat(0x0202);                                  //front & back porch periods = 2
		LCDOutIns(LCD_INS_DISP_CTRL3);
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_DISP_CTRL4);
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_RGB_DISP_IF_CTRL1);
		LCDOutDat(0x0000);                                  //select system interface                                
		LCDOutIns(LCD_INS_FRM_MARKER_POS);
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_RGB_DISP_IF_CTRL2);
		LCDOutDat(0x0000);                                        
		LCDOutIns(LCD_INS_POW_CTRL1);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_POW_CTRL2);
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_POW_CTRL3);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_POW_CTRL4);
		LCDOutDat(0x0000);                                         
		_delay_ms(300);
		LCDOutIns(LCD_INS_POW_CTRL1);
		LCDOutDat(0x17B0);
		LCDOutIns(LCD_INS_POW_CTRL2);
		LCDOutDat(0x0137);                                         
		_delay_ms(100);
		LCDOutIns(LCD_INS_POW_CTRL3);
		LCDOutDat(0x013C);
		_delay_ms(100);
		LCDOutIns(LCD_INS_POW_CTRL4);
		LCDOutDat(0x1400);
		LCDOutIns(LCD_INS_POW_CTRL7);
		LCDOutDat(0x0007);
		_delay_ms(100);
		LCDOutIns(LCD_INS_GRAM_HOR_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_GRAM_VER_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_GAMMA_CTRL1);
		LCDOutDat(0x0007);
		LCDOutIns(LCD_INS_GAMMA_CTRL2);
		LCDOutDat(0x0504);
		LCDOutIns(LCD_INS_GAMMA_CTRL3);
		LCDOutDat(0x0703);
		LCDOutIns(LCD_INS_GAMMA_CTRL4);
		LCDOutDat(0x0002);
		LCDOutIns(LCD_INS_GAMMA_CTRL5);
		LCDOutDat(0x0707);
		LCDOutIns(LCD_INS_GAMMA_CTRL6);
		LCDOutDat(0x0406);
		LCDOutIns(LCD_INS_GAMMA_CTRL7);
		LCDOutDat(0x0006);
		LCDOutIns(LCD_INS_GAMMA_CTRL8);
		LCDOutDat(0x0404);
		LCDOutIns(LCD_INS_GAMMA_CTRL9);
		LCDOutDat(0x0700);
		LCDOutIns(LCD_INS_GAMMA_CTRL10);
		LCDOutDat(0x0A08);
		LCDOutIns(LCD_INS_HOR_START_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_HOR_END_AD);
		LCDOutDat(0x00EF);
		LCDOutIns(LCD_INS_VER_START_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_VER_END_AD);
		LCDOutDat(0x013F);
		LCDOutIns(LCD_INS_GATE_SCAN_CTRL1);
		LCDOutDat(0x2700);
		LCDOutIns(LCD_INS_GATE_SCAN_CTRL2);
		LCDOutDat(0x0001);
		LCDOutIns(LCD_INS_GATE_SCAN_CTRL3);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG1_DISP_POS);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG1_START_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG1_END_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG2_DISP_POS);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG2_START_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG2_END_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL1);
		LCDOutDat(0x0010);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL2);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL3);
		LCDOutDat(0x0003);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL4);
		LCDOutDat(0x0110);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL5);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL6);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_DISP_CTRL1);
		LCDOutDat(0x0173);
	} //****  ILI9320
	
	if (driver_code == 0x9325) 		//****  ILI9325
	{
		LCDOutIns(0x00E3);
		LCDOutDat(0x3008);                                //set the internal timing
		LCDOutIns(0x00E7);
		LCDOutDat(0x0012);                                //set the internal timing
		LCDOutIns(0x00EF);
		LCDOutDat(0x1231);                                //set the internal timing
		LCDOutIns(LCD_INS_START_OSC);
		LCDOutDat(0x0001);                                //start oscillator
		_delay_ms(100);
		LCDOutIns(LCD_INS_DRIV_OUT_CTRL);
		LCDOutDat(0x0100);                                //set SS, SM
		LCDOutIns(LCD_INS_DRIV_WAV_CTRL);
		LCDOutDat(0x0700);                                //set 1 line inversion
		LCDOutIns(LCD_INS_ENTRY_MOD);
		LCDOutDat(LCD_VAL_ENTRY_MOD);                     //set GRAM write direction, BGR=0
		LCDOutIns(LCD_INS_RESIZE_CTRL);										// Resize register
		LCDOutDat(0x0000); //no resizing
		LCDOutIns(LCD_INS_DISP_CTRL2);										// set the back porch and front porch
		LCDOutDat(0x0202); //periods = 2
		LCDOutIns(LCD_INS_DISP_CTRL3);										// set non-display area refresh cycle ISC[3:0]
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_DISP_CTRL4);										// FMARK function
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_RGB_DISP_IF_CTRL1);							// RGB interface setting
		LCDOutDat(0x0000); //select system interface                                
		LCDOutIns(LCD_INS_FRM_MARKER_POS);								// Frame marker Position
		LCDOutDat(0x0000);                                         
		LCDOutIns(LCD_INS_RGB_DISP_IF_CTRL2);							// RGB interface polarity
		LCDOutDat(0x0000);                                        
		// ----------- Power On sequence ----------//
		LCDOutIns(LCD_INS_POW_CTRL1);											// SAP, BT[3:0], AP, DSTB, SLP, STB
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_POW_CTRL2);											// DC1[2:0], DC0[2:0], VC[2:0]
		LCDOutDat(0x0007);                                         
		LCDOutIns(LCD_INS_POW_CTRL3);											// VREG1OUT voltage
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_POW_CTRL4);											// VDV[4:0] for VCOM amplitude
		LCDOutDat(0x0013); //(0x0000);
		_delay_ms(500);																		// Dis-charge capacitor power voltage
		
		LCDOutIns(LCD_INS_POW_CTRL1);											// SAP, BT[3:0], AP, DSTB, SLP, STB
		LCDOutDat(0x1290); //(0x17B0);
		LCDOutIns(LCD_INS_POW_CTRL2);											// DC1[2:0], DC0[2:0], VC[2:0]
		LCDOutDat(0x0527); //0x0227);                                         
		_delay_ms(100);
		
		LCDOutIns(LCD_INS_POW_CTRL3);											// Internal reference voltage= Vci;
		LCDOutDat(0x0018); //(0x001A);
		_delay_ms(100);
		
		LCDOutIns(LCD_INS_POW_CTRL4);											// Set VDV[4:0] for VCOM amplitude
		LCDOutDat(0x1000); //(0x1800);
		LCDOutIns(LCD_INS_POW_CTRL7);											// Set VCM[5:0] for VCOMH
		LCDOutDat(0x001E); //(0x002A);

		LCDOutIns(LCD_INS_FRM_RATE_COL_CTRL);							// Set Frame Rate
		LCDOutDat(0x000D);
		_delay_ms(100);
		// ----------- Adjust GRAM ----------//
		LCDOutIns(LCD_INS_GRAM_HOR_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_GRAM_VER_AD);
		LCDOutDat(0x0000);
		// ----------- Adjust the Gamma Curve ----------//
		LCDOutIns(LCD_INS_GAMMA_CTRL1);
		LCDOutDat(0x0007);
		LCDOutIns(LCD_INS_GAMMA_CTRL2);
		LCDOutDat(0x0605);
		LCDOutIns(LCD_INS_GAMMA_CTRL3);
		LCDOutDat(0x0106);
		LCDOutIns(LCD_INS_GAMMA_CTRL4);
		LCDOutDat(0x0206);
		LCDOutIns(LCD_INS_GAMMA_CTRL5);
		LCDOutDat(0x0808);
		LCDOutIns(LCD_INS_GAMMA_CTRL6);
		LCDOutDat(0x0007);
		LCDOutIns(LCD_INS_GAMMA_CTRL7);
		LCDOutDat(0x0201);
		LCDOutIns(LCD_INS_GAMMA_CTRL8);
		LCDOutDat(0x0007);
		LCDOutIns(LCD_INS_GAMMA_CTRL9);
		LCDOutDat(0x0602);
		LCDOutIns(LCD_INS_GAMMA_CTRL10);
		LCDOutDat(0x0808);
		//------------------ Set GRAM area ---------------//
		LCDOutIns(LCD_INS_HOR_START_AD); 									// Horizontal GRAM Start Address
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_HOR_END_AD);										// Horizontal GRAM End Address
		LCDOutDat(0x00EF);
		LCDOutIns(LCD_INS_VER_START_AD);									// Vertical GRAM Start Address
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_VER_END_AD);										// Vertical GRAM Start Address
		LCDOutDat(0x013F);
		LCDOutIns(LCD_INS_GATE_SCAN_CTRL1);								// Gate Scan Line  A700
		LCDOutDat(0xA700);
		LCDOutIns(LCD_INS_GATE_SCAN_CTRL2);								// NDL, VLE, REV
		LCDOutDat(0x0001);
		LCDOutIns(LCD_INS_GATE_SCAN_CTRL3);								// set scrolling line
		LCDOutDat(0x0000);
		//-------------- Partial Display Control ---------//
		LCDOutIns(LCD_INS_PART_IMG1_DISP_POS);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG1_START_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG1_END_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG2_DISP_POS);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG2_START_AD);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PART_IMG2_END_AD);
		LCDOutDat(0x0000);
		//-------------- Panel Control -------------------//
		LCDOutIns(LCD_INS_PANEL_IF_CTRL1);
		LCDOutDat(0x0010);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL2);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL3);
		LCDOutDat(0x0003);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL4);
		LCDOutDat(0x0110);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL5);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_PANEL_IF_CTRL6);
		LCDOutDat(0x0000);
		LCDOutIns(LCD_INS_DISP_CTRL1);
		LCDOutDat(0x0133); // 262K color, normal display, base image display oprate and turns off partial image
	} //****  ILI9325
} //*LCDInit

void LCDPortInit(void)
{
	#if TFT_PORT_INTERFACE
		sbi(LCD_CS_DDR,LCD_CS_BIT);
		sbi(LCD_RS_DDR,LCD_RS_BIT);
		sbi(LCD_RD_DDR,LCD_RD_BIT);
		sbi(LCD_WR_DDR,LCD_WR_BIT);

		sbi(LCD_CS_PRT,LCD_CS_BIT);
		sbi(LCD_RS_PRT,LCD_RS_BIT);
		sbi(LCD_RD_PRT,LCD_RD_BIT);
		sbi(LCD_WR_PRT,LCD_WR_BIT);		
	#else
    MCUCR = _BV(SRE) | _BV(SRW);							// enable external SRAM (memory mapped TFT) and one wait state
	#endif
	
	sbi(LCD_RST_DDR,LCD_RST_BIT);
	cbi(LCD_RST_PRT,LCD_RST_BIT);
	
	sbi(LCD_BL_DDR,LCD_BL_BIT);
	cbi(LCD_BL_PRT,LCD_BL_BIT);
}//*lcd_hw_init

//show picture from code memory with specific size
void LCDShowPic2(int sx,int ex,int sy,int ey,const unsigned short *pic,LCD_mode_t mode)
{
	unsigned long 	k = 0;
	unsigned short 	color;
	unsigned int 		i,j;
	
	LCDSetArea(sx, ex, sy, ey);

  if (mode == LCD_MODE_FULL)
  {
		for (j=0; j<newY; j++)
			for (i=0; i<newX; i++)
			{
				LCDOutDat(pgm_read_word(&pic[k]));
				k++;
			}
	}
	else if (mode == LCD_MODE_NORMAL)
	{
		for (j=0; j<newY; j++)
			for (i=0; i<newX; i++)
			{
				if (pgm_read_word(&pic[k]) == LCD_COL_WHITE)
				{
					color = LCDInDat();                 					// ignore invalid data
					color = LCDInDat();
					LCDOutDat(color);
				}
				else
				{
					LCDOutDat(pgm_read_word(&pic[k]));
				}
				k++;
			}
  }
} //*LCDShowPic2

void LCDSetArea(int sx,int ex,int sy,int ey)
{
	if (sx < LCD_margin_xl)    				sx = LCD_margin_xl;
	if (ex > LCD_margin_xr)    				ex = LCD_margin_xr;
	if (sy < LCD_margin_yu)    				sy = LCD_margin_yu;
	if (ey > LCD_margin_yl)    				ey = LCD_margin_yl;
	newX = ex - sx + 1;
	
	LCDOutIns(LCD_INS_START_ADX);			LCDOutDat(sx);
	LCDOutIns(LCD_INS_END_ADX);				LCDOutDat(ex);
	LCDOutIns(LCD_INS_GRAM_ADX);			LCDOutDat(sx);

	#if !LCD_ORN_PORTRAIT
		sy = LCD_SIZE_Y - 1 - sy;       										// mirror start y address
		ey = LCD_SIZE_Y - 1 - ey;       										// mirror end 	y address
		newY = sy - ey + 1;

		LCDOutIns(LCD_INS_START_ADY);		LCDOutDat(ey);
		LCDOutIns(LCD_INS_END_ADY);			LCDOutDat(sy);
		LCDOutIns(LCD_INS_GRAM_ADY);		LCDOutDat(sy);
	#else
		newY = ey - sy + 1;

		LCDOutIns(LCD_INS_START_ADY);		LCDOutDat(sy);
		LCDOutIns(LCD_INS_END_ADY);			LCDOutDat(ey);
		LCDOutIns(LCD_INS_GRAM_ADY);		LCDOutDat(sy);
	#endif

	LCDOutIns(LCD_INS_RW_GRAM);
} //LCDSetArea

void LCDGotoXY(int x,int y)
{
	LCDOutIns(LCD_INS_GRAM_ADX); // initial settings for the GDDRAM X address in the address counter (AC).
	LCDOutDat(x);
		
	LCDOutIns(LCD_INS_GRAM_ADY); // initial settings for the GDDRAM Y address in the address counter (AC).
	LCDOutDat(y);
	
	LCDOutIns(LCD_INS_RW_GRAM);
}	//LCDGotoXY

void LCDFillRect(int sx,int ex,int sy,int ey,unsigned short color,LCD_mode_t mode) 		//draw a rectangular
{
	unsigned int i,j;
	
	LCDSetArea(sx, ex, sy, ey);
	
	if ((mode == LCD_MODE_NORMAL) || (mode == LCD_MODE_FULL))
	{
		for (j=0; j<newY; j++)
	  	for (i=0; i<newX; i++)
			{
				LCDOutDat(color);
			}
	}
	else if (mode == LCD_MODE_INVERSE)
  {
  	for (j=0; j<newY; j++)
    	for (i=0; i<newX; i++)
      {
      	color = LCDInDat();                 						// ignore invalid data
      	color = LCDInDat();
      	LCDOutDat(~color);
      }
	}
} //*LCDFillRect

void LCDPutPixel(int x,int y,unsigned short color,LCD_mode_t mode)
{
	LCDGotoXY(x, y);

	if ((mode == LCD_MODE_NORMAL) || (mode == LCD_MODE_FULL))
	{
		LCDOutDat(color);
	}
	else if (mode == LCD_MODE_INVERSE)
  {
   color = LCDInDat();     															// ignore invalid data
   color = LCDInDat();
   LCDOutDat(~color);
	}
}	//LCDPutPixel

void LCDFillCirc(int cx,int cy,int rad,unsigned short color, LCD_mode_t mode) 				//draw a circle
{
	int sx,sy,ex,ey;
	int i,j;
	unsigned short color_buf;
	unsigned short rad2 = rad*rad;

	sx = cx - rad;
	ex = cx + rad;
	sy = cy - rad;
	ey = cy + rad;

	LCDSetArea(sx, ex, sy, ey);

  if (mode == LCD_MODE_NORMAL)
  {
  	for (j=sy-cy; j<=ey-cy; j++)
			for (i=sx-cx; i<=ex-cx; i++)
			{
				if ((i)*(i) + (j)*(j) < rad2)
			  {
			  	LCDOutDat(color);
			  }
				else
			  {
			    color_buf = LCDInDat();                 // ignore invalid data
			    color_buf = LCDInDat();
			    LCDOutDat(color_buf);
			  }
			}
	}
	else if (mode == LCD_MODE_INVERSE)
	{
		for (j=sy-cy; j<=ey-cy; j++)
	  	for (i=sx-cx; i<=ex-cx; i++)
	    {
	    	if ((i)*(i) + (j)*(j) < rad2)
	      {
	      	color_buf = LCDInDat();                 			// ignore invalid data
	      	color_buf = LCDInDat();
	      	LCDOutDat(~color_buf);
	      }
	    	else
	      {
	      	color_buf = LCDInDat();                 			// ignore invalid data
	      	color_buf = LCDInDat();
	      	LCDOutDat(color_buf);
	      }
	    }
	}
	else if (mode == LCD_MODE_FULL)
	{
		for (j=sy-cy; j<=ey-cy; j++)
	  	for (i=sx-cx; i<=ex-cx; i++)
			{
				if ((i)*(i) + (j)*(j) < rad2)
				{
			    LCDOutDat(color);
				}
				else
				{
			  	LCDOutDat(back_color);
				}
			}
	}
} //*LCDFillCirc

void LCDSetMargins(int xl,int xr,int yu,int yl) 				//set margins for FillRect,FillCirc
{
	LCD_margin_xl = xl;
	LCD_margin_xr = xr;
	LCD_margin_yu = yu;
	LCD_margin_yl = yl;
} //*LCDSetMargins

void LCDSetMarginsDefault(void) 												//Reset margins to default value
{
	LCD_margin_xl = 0;
	LCD_margin_xr = LCD_SIZE_X - 1;
	LCD_margin_yu = 0;
	LCD_margin_yl = LCD_SIZE_Y - 1;
} //*LCDSetMarginsDefault

void buf_store(unsigned char charactor)
{
	unsigned char i,j;
	int 					char_p = charactor*FONT_SIZE;
	
	first_non_zero = FONT_BIT_WIDTH;
	last_non_zero = 0;
	
	for (i=0; i<FONT_BIT_WIDTH; i++)
		for (j=0; j<FONT_BYTE_HEIGHT; j++)
		{
	  	if(pgm_read_byte(&font[char_p]))
	    {
	    	last_non_zero = i;
	      if (first_non_zero == FONT_BIT_WIDTH)
	      {
	      	if (i)
	        	first_non_zero = i-1;
	        else
	        	first_non_zero = 0;
	      }
	    }
	    if (bold_on && i)
	    	char_buf[i][j] = pgm_read_byte(&font[char_p]) | pgm_read_byte(&font[char_p-FONT_BYTE_HEIGHT]);
	    else
			  char_buf[i][j] = pgm_read_byte(&font[char_p]);

	    char_p++;
	  }
	
	if (bold_on)
	{
	  last_non_zero++;
	}
	if (charactor == ' '-0x20)
	{          
		first_non_zero = 0;
	  last_non_zero = FONT_BIT_WIDTH/2;
	}
} //*buf_store

void buf_clear(void)
{
	unsigned char i,j;

	for (i=0; i<FONT_BIT_WIDTH+2; i++)
  	for (j=0; j<FONT_BYTE_HEIGHT; j++)
    	{
      	char_buf[i][j] = 0;
      }
} //*buf_clear

unsigned char buf_read(unsigned char column,unsigned char row)
{
	unsigned char read_pixel;

	if (vary_width_on)
  {
  	column += first_non_zero;        
  }
	if (row < 8)
	{
		read_pixel = (char_buf[column][0] >> (7-row)) & 0x01;
	}
	else
  {
    row = row - 8;
    read_pixel = (char_buf[column][1] >> (7-row)) & 0x01;
  }

	return (read_pixel);
} //*buf_read

void LCDCharDisp(char charactor,int sx,int sy,LCD_mode_t mode) 																		//low level function to print a character on LCD
{
	unsigned char 	i,j;
	int 			ex,ey;
	unsigned short 	c;
	
	buf_store(charactor - 0x20);
	
	if (vary_width_on)		ex = sx + (last_non_zero - first_non_zero) + char_gap - 1;
	else									ex = sx + FONT_WIDTH - 1;
	
	ey = sy + FONT_HEIGHT - 1;
	
	LCDSetArea(sx, ex, sy, ey);

  if (mode == LCD_MODE_NORMAL)
  {
  	for (j=0; j<newY; j++)
    	for (i=0; i<newX; i++)
      	{
					if (buf_read(i,j))
					{
						LCDOutDat(font_color);
					}
					else
					{
						c = LCDInDat();                 						// ignore invalid data
						c = LCDInDat();
						LCDOutDat(c);
					}
				}
	}
	else if (mode == LCD_MODE_INVERSE)
	{
  	for (j=0; j<newY; j++)
    	for (i=0; i<newX; i++)
      {
      	c = LCDInDat();                         				// ignore invalid data
        c = LCDInDat();
        if (buf_read(i,j))
      	{
					LCDOutDat(~c);
				}
				else
				{
					LCDOutDat(c);
				}
			}
	}
	else	if (mode == LCD_MODE_FULL)
	{
		for (j=0; j<newY; j++)
	  	for (i=0; i<newX; i++)
			{
	    	if (buf_read(i,j))
	      {
	      	LCDOutDat(font_color);
	      }
	      else
	      {
	      	LCDOutDat(back_color);
	      }
	    }
	}
} //*LCDCharDisp

void LCDSetOffset(int x,int y) 							//set LCD offset for character display
{
	offsetx = x;
	offsety = y;
} //*LCDSetOffset

int LCDGetLineY(unsigned char line)
{
	return(offsety + line*FONT_HEIGHT);	
}	//*LCDGetlineY

void LCDPrintStr(unsigned char line,unsigned char column,char *str,LCD_mode_t mode) 													//print string on LCD
{
	int i = 0;
	
	int posx,posy;
	posx = offsetx + column*FONT_WIDTH;
	posy = offsety + line*FONT_HEIGHT;
	
	while(str[i])
	{
		LCDCharDisp(str[i],posx,posy,mode);
	  
	  if (vary_width_on)
	  	posx += last_non_zero-first_non_zero+char_gap;
	  else
	  	posx += FONT_WIDTH;
    
		i++;
  }
} //*LCDPrintStr

void LCDPrintTxt(unsigned char line,unsigned char column,const char *txt,LCD_mode_t mode) 										//print text from code memory
{
	int i = 0;
	int posx,posy;
	posx = offsetx + column*FONT_WIDTH;
	posy = offsety + line*FONT_HEIGHT;
	
	while(pgm_read_byte(&txt[i]))
	{
		LCDCharDisp(pgm_read_byte(&txt[i]),posx,posy,mode);
		
		if (vary_width_on)
			posx += last_non_zero-first_non_zero+char_gap;
		else
			posx += FONT_WIDTH;
		
		i++;
	}
} //*LCDPrintTxt

void LCDPrintCh(unsigned char line,unsigned char column,char c,LCD_mode_t mode) 															//print a character on LCD
{
	int posx,posy;
	posx = offsetx + column*FONT_WIDTH;
	posy = offsety + line*FONT_HEIGHT;
	
	LCDCharDisp(c,posx,posy,mode);
} //*LCDPrintCh

void LCDSetCursor(unsigned char line,unsigned char column, LCD_mode_t mode)
{
	LCDcolumn 	= column;
	LCDline 		= line;
	
	LCDposx 		= offsetx + column*FONT_WIDTH;
	LCDposy 		= offsety + line*FONT_HEIGHT;
	
	LCDmode 		= mode;
}	//LCDSetCursor

void LCD_print(char c)
{
	if(c == '\r')		return;
	if(c == '\n')
	{
		LCDposy += FONT_HEIGHT;
		LCDposx = offsetx + LCDcolumn*FONT_WIDTH;
		return;
	}

	LCDCharDisp(c, LCDposx, LCDposy, LCDmode);
	  
  if (vary_width_on)
  	LCDposx += last_non_zero-first_non_zero+char_gap;
  else
  	LCDposx += FONT_WIDTH;	
}	//LCD_print

unsigned int LCDGetCharWidth(char c)
{
	unsigned int res;
	
	if (vary_width_on)
  {
    buf_store(c-0x20);
    res = last_non_zero - first_non_zero + char_gap;
    return (res);
  }
	else
  	return (FONT_BIT_WIDTH);
} //*LCDGetCharWidth

unsigned int LCDGetStringWidth(char *str)
{
	unsigned int i   = 0;
	unsigned int res = 0;
	
	while (str[i])
	{
		res += LCDGetCharWidth(str[i]);
		i++;
	}
	
return (res);
} //*LCDGetStringWidth

void LCDSetBold(unsigned char on)
{
	bold_on = on;
} //*LCDSetBold
        
unsigned char LCDGetBold(void)
{
	return (bold_on);
} //*LCDGetBold

void LCDSetVaryWidth(unsigned char on)
{
	vary_width_on = on;
} //*LCDSetVaryWidth

unsigned char LCDGetVaryWidth(void)
{
	return (vary_width_on);
} //*LCDGetVaryWidth

void LCDCfgFont(const unsigned char* _font, unsigned char width, unsigned char height_div_8, unsigned char gap)
{
	font 							= _font;
	FONT_BIT_WIDTH 		= width;
	FONT_BYTE_HEIGHT 	= height_div_8;
	FONT_SIZE 				= width*height_div_8;
	FONT_WIDTH 				= FONT_BIT_WIDTH;
	FONT_HEIGHT				= FONT_BYTE_HEIGHT*8;
	char_gap 					= gap;
	
	buf_clear();  
} //*LCDCfgFont

/** Just a delay */
void delay450ns(unsigned char n)
{
	while(n--)
	{	
		//6 nops for about 450ns at 20MHz?    
		asm volatile(
			"nop\n\t"
			"nop\n\t"
			"nop\n\t"
			"nop\n\t"
			"nop\n\t"
			"nop\n\t"
			);
	}
} //*delay450ns
