//-----------------------------------------------------------------------------
// Copyright:      RAD Electronic Co. LTD,
// Author:         Sh. Nourbakhsh Rad
// Remarks:        
// known Problems: none
// Version:        20.03.2011
// Description:    ATMEGA128 interface
//-----------------------------------------------------------------------------

//	Include Headers
//*****************************************************************************
#include <avr/io.h>
#include <stdio.h>			//for fprintf using!
#include <compat/deprecated.h>
#include <util/delay.h>

//--------------------------------------------------
#include "TFT\ili9325.h"
#include "Graphic\Graphic.h"

#include "FONT\font\f9x14.h"
#include "FONT\font\AF12x16.h"
#include "FONT\Font.h"


//	Constants and Varables
//*****************************************************************************
#define True				1
#define False				0


//Temp Const.



//	Functions Prototype
//*****************************************************************************



//	<<< main function >>>
//*****************************************************************************
int main (void)
{
	unsigned char 		i = 0;
	
	LCDInit();					//*** ili9325 TFT-LCD initiation
		
	_delay_ms(500);	 		//Wait 500ms	
 	LCD_BL_ON; 
	
	LCD_CLS(WHITE);	

	unsigned int 		y  = 0;
	unsigned char		yp = (GetMaxY()+1)/20;
	
	RectangleFill(0, y, GetMaxX(), y+yp,  DARK_BLUE);					y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  BLUE);							y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  LIGHT_BLUE);				y += yp;
	
	RectangleFill(0, y, GetMaxX(), y+yp,  DARK_GREEN);				y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  GREEN);							y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  LIGHT_GREEN);				y += yp;
	
	RectangleFill(0, y, GetMaxX(), y+yp,  DARK_YELLOW);				y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  YELLOW);						y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  LIGHT_YELLOW);			y += yp;
	
	RectangleFill(0, y, GetMaxX(), y+yp,  DARK_RED);					y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  RED);								y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  LIGHT_RED);					y += yp;
	
	RectangleFill(0, y, GetMaxX(), y+yp,  MAGENTA);						y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  CYAN);							y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  BROWN);							y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  SILVER);						y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  GOLD);							y += yp;
	
	RectangleFill(0, y, GetMaxX(), y+yp,  BLACK);							y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  GRAY);							y += yp;
	RectangleFill(0, y, GetMaxX(), y+yp,  WHITE);							y += yp;

	_delay_ms(3000);
	LCD_CLS(BLUE);	
	
	//-------------------------------------
	/**** for printf use ****/
	static FILE mystdout = FDEV_SETUP_STREAM(PutChar, NULL, _FDEV_SETUP_WRITE);
  stdout = &mystdout;

	//-------------------------------------
	_delay_ms(200);
	LcdHorizontal(1); //(LCD_ORN_PORTRAIT);
	SetBkColor(YELLOW);
	SetFgColor(RED);

	//-------------------------------------
	LcdFont(f9x14);

	LcdFontXScale(1);
	LcdFontYScale(2);
	SetLetter(E_LETTER);

	TextBox (10, 10,  GetMaxX()-10,  10+40, "English / Persian font test!",  ALINE_CENTER | BORDER_RECT | BORDER_FILL | bvl(8));
	
	LcdFontXScale(2);
	LcdFontYScale(2);
	
	SetLine(4, 1);
	SetCursorX(10);
	
	SetFgColor(LIGHT_BLUE);
	printf("Date : %d/03/%d\n",1390,29);

	//-------------------------------------
	//-------------------------------------
	
	LcdFont(AF12x16);

	LcdFontSpace(3);

	LcdFontXScale(1);
	LcdFontYScale(3);

	SetFgColor(WHITE);
	TextBox(10, 180, GetMaxX()-10,  180+50, "by Sh. Nourbakhsh Rad", ALINE_CENTER);

	_delay_ms(3000);
	LCD_CLS(BLUE);	

	//-------------------------------------
	LcdFontXScale(2);
	LcdFontYScale(2);

	SetLine(2,3);
	PutChar('H');
	PutChar('e');
	PutChar('l');
	PutChar('l');
	PutChar('o');
	PutChar('!');
	
	SetLetter(P_LETTER);
	SetLine(4,3);
	PutChar(0x8A);
	PutChar(0xDC);
	PutChar(0xDC);
	PutChar(0x9F);
	PutChar(0xE3);
	PutChar('!');

	_delay_ms(2000);
	LCD_CLS(BLUE);
	
	//-------------------------------------
	SetFgColor(MAGENTA);
	
	LcdFontXScale(3);
	LcdFontYScale(4);

	SetLine(1,0);
	LcdRot(1); //90
	LcdReverse(0);
	Puts(" ");

	SetLine(2,0);
	LcdReverse(1);
	Puts(" ");

	_delay_ms(2000);
	LCD_CLS(BLUE);
	
	//-------------------------------------
	SetBkColor(GREEN);
	
	LcdRot(0);
	LcdReverse(0);

	LcdFontXScale(1);
	LcdFontYScale(2);

	TextBox (10, 10,  GetMaxX()-10,  10+40, "  ",  ALINE_CENTER | BORDER_RECT | BORDER_FILL | bvl(10));
	TextBox (10, 60,  GetMaxX()-10,  60+40, "",      ALINE_RIGHT   | BORDER_RECT | BORDER_FILL);
	TextBox (10, 110, GetMaxX()-10, 110+40, " ",  ALINE_LEFT  | BORDER_RECT | bvl(10));
	SetLetter(E_LETTER);
	TextBox (10, 190, GetMaxX()-10, 190 +LcdFontHeight()*3, "Sh. Nourbakhsh Rad\n\n", ALINE_CENTER | BORDER_RECT | BORDER_FILL);
	
	SetFgColor(YELLOW);
	LcdFontXScale(2);
	LcdFontYScale(2);
	SetLetter(P_LETTER);

	Puts(" : 28/03/1390");

	_delay_ms(3000);
	LCD_CLS(BLUE);
	
	//-------------------------------------
	LcdFontYScale(3);
	TextBox(0, 20, GetMaxX(), 20+60, " !", ALINE_CENTER);

	LcdFontXScale(2);
	LcdFontYScale(6);

	SetFgColor(RED);
	DrawStringAt(1,1,"  ȍ ",GetFgColor(),GetBkColor());
	
	SetLetter(E_LETTER);
	DrawStringAt(2, 4, "ECA",MAGENTA,GetBkColor());
} //main
