//-----------------------------------------------------------------------------
// Copyright:      RAD Electronic Co. LTD,
// Author:         jaruwit supa, Base on FontEditor written by H. Reddmann
//								 Modified by Sh. Nourbakhsh Rad for Persian and Arabic font
//								 and fixed some errors
// Remarks:        
// known Problems: none
// Version:        20.03.2011
// Description:    Font Library
//-----------------------------------------------------------------------------

#ifndef _FONT_H_
	#define _FONT_H_

	#include <avr/io.h>
	#include <inttypes.h>
	#include <avr/pgmspace.h>

	#include "Graphic\Graphic.h"

	
	typedef enum {
		E_LETTER,
	  P_LETTER
	} Lt_Mode;


	/////////////////////////////////////////////////////////
	#define STYLE_NONE								0
	#define STYLE_NO_ZERO   					1
	#define STYLE_NO_SPACE  					2
	
	#define ALINE_LEFT								0
	#define ALINE_CENTER							1
	#define ALINE_RIGHT								2
	#define ALINE_MARK								(ALINE_LEFT | ALINE_CENTER | ALINE_RIGHT)
	
	
	#define BORDER_NONE								0x00
	#define BORDER_RECT								0x04
	#define BORDER_FILL								0x08
	#define BORDER_BEVEL							0xF0	// bevel radius 0x00(rectangle), 0x10-0xF0(radius size)
	#define BORDER_MASK								(BORDER_FILL | BORDER_RECT)
	#define bvl(x)										(x<<4)


	/////////////////////////////////////////////////////////
	extern void LcdFont(uint8_t *pointer);

	extern void LcdRot(uint8_t r);
	extern void LcdReverse(uint8_t rv);
	extern void LcdHorizontal(uint8_t hv);

	extern void LcdFontFixed(uint8_t typ);
	extern void	LcdNonTransparence(uint8_t nt);
	
	extern void	LcdFgColor(uint16_t color);
	extern void	LcdBkColor(uint16_t color);
	
	extern void SetLine(unsigned char line,unsigned char column);

	extern unsigned int CalcTextWidth(char *Text);
	extern unsigned int CalcTextHeight(char *Text);

	extern void PutChar(uint8_t c);
	extern void Puts(char *c);
	extern void PutsP(char *Text);

	extern void PutLong(uint32_t src, uint8_t digit, uint8_t decimal, uint8_t Parameter);
	extern void PutInt(uint16_t src, uint8_t digit, uint8_t decimal, uint8_t Parameter);
	extern void PutByte(uint8_t src, uint8_t digit, uint8_t decimal, uint8_t Parameter);
	
	extern void PutText(uint16_t left, uint16_t top, uint16_t right, uint16_t bottom, char *Text, uint8_t aline);
	extern void PutTextP(uint16_t left, uint16_t top, uint16_t right, uint16_t bottom, const char *Text, uint8_t aline);
	extern void TextBox(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, char *str, uint8_t style);
	extern void TextBoxP(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, char *str, uint8_t style);

	//////////////
	extern void SetLetter(Lt_Mode L);
	extern void PutsPE(char *str);

	extern void PutCharPE(unsigned char c);
	extern void PutCharEN(unsigned char c);
	
	extern unsigned int CalcTextWidthEN(char *str);
	extern unsigned int CalcTextWidthPE(char *str);
	
	/////////////////////////////////////////////////////////	
	extern uint8_t 										rot;
	extern uint8_t 										Reverse;
	extern uint8_t										Horizontal;

	extern uint16_t										FgColor;
	extern uint16_t										BkColor;
	extern uint8_t 										FontFixed;
	extern uint8_t										NonTransparence;
	
	extern uint8_t 										FontWidth;
	extern uint8_t 										FontHeight;
	extern uint8_t 										FontXScale;
	extern uint8_t 										FontYScale;
	extern uint8_t 										FontSpace;
	
	extern unsigned int 							cursorX;		// x position
	extern unsigned int 							cursorY;		// y position

	extern uint8_t										peLETTER;		//English or Persian letter

	/////////////////////////////////////////////////////////	
	#define GetLetter() 							peLETTER

	#define GetCursorX() 							cursorX
	#define GetCursorY() 							cursorY
	#define SetCursorX(x) 						cursorX = x
	#define SetCursorY(y) 						cursorY = y
	#define SetCursor(x,y) 						{cursorX = x; cursorY = y;}
	
	#define LcdRot(n)									rot = n
	#define LcdReverse(n)							Reverse = n
	#define LcdHorizontal(n)					Horizontal = n
	
	#define LcdFontFixed(n)						FontFixed = n
	#define LcdNonTransparence(n)			NonTransparenz = n
	
	#define SetFgColor(n)							FgColor = n
	#define SetBkColor(n)							BkColor = n
	#define GetFgColor()							FgColor
	#define GetBkColor()							BkColor
	
	#define LcdFontXScale(n)					FontXScale = n
	#define LcdFontYScale(n)					FontYScale = n
	#define LcdFontSpace(n)						FontSpace  = n
	
	#define LcdFontWidth() 	 					FontWidth
	#define LcdFontHeight()						FontHeight
	
	// complex function
	#define DrawStringAt(l,c,s,fk,bk)			SetLine(l,c); SetFgColor(fk); SetBkColor(bk); Puts(s)
	#define DrawStringAtP(l,c,s,fk,bk)		SetLine(l,c); SetFgColor(fk); SetBkColor(bk); PutsP(s)

#endif	//_FONT_H_
