//-----------------------------------------------------------------------------
// Copyright:      RAD Electronic Co. LTD,
// Author:         Sh. Nourbakhsh Rad
// Remarks:        
// known Problems: none
// Version:        1.5.0
// Description:    GLCD's graphic founctions
//-----------------------------------------------------------------------------

#include "graphic.h"

// Description	: Draw a line on a graphic LCD using Bresenham's
// Input        : x1,y1 - starting coordinates
//              : x2,y2 - ending coordinates
//********************************************************************
void Line(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned short color)
{
	signed int  	x, y, addx, addy, dx, dy;
	signed long 	P;
	int 					i;

	dx = abs((signed int)(x2 - x1));
	dy = abs((signed int)(y2 - y1));
	x  = x1;
	y  = y1;

	addx = addy = 1;
	if(x1 > x2)		addx = -1;
	if(y1 > y2)		addy = -1;

	if (dx >= dy)
	{
		P = 2L*dy - dx;
		for (i=0; i<=dx; ++i)
		{
	  	PutPixel(x, y, color);
			if(P < 0)
	  	{
	    	P += 2*dy;
	    	x += addx;
	  	}
			else
			{
	    	P += 2*dy - 2*dx;
	    	x += addx;
	    	y += addy;
	  	}
		}
	}
	else
	{
		P = 2L*dx - dy;
		for(i=0; i<=dy; ++i)
		{
	  	PutPixel(x, y, color);
	  	if(P < 0)
	  	{
	    	P += 2*dx;
	    	y += addy;
	  	}
	  	else
	  	{
	    	P += 2*dx - 2*dy;
	    	x += addx;
	    	y += addy;
	  	}
		}
	}
}	//Line

// Description  : Draw a rectangle on a graphic LCD
// Input        : x1,y1 - starting coordinates
//              : x2,y2 - ending coordinates
//********************************************************************
void Rectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned short color)
{
		RectangleFill(x1, y1, x2, y1, color);    // top
    RectangleFill(x1, y2, x2, y2, color);    // bottom
    RectangleFill(x1, y1, x1, y2, color);    // left
    RectangleFill(x2, y1, x2, y2, color);    // right
}	//Rectangle

// Description	: Draws a beveled figure on the screen. 
// Input       	: x1, y1 - coordinate position of the upper left center
//		      		: x2, y2 - coordinate position of the lower right center
//             	: rad    - defines the redius of the circle,
//             	: fill   - fill yes or no
//********************************************************************
void RoundRectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, unsigned int radius, unsigned char fill, unsigned short color)
{
	signed int 		a, b, P;
	signed int 		bx, ay;

	a  = 0;       				// increment by 1
	b  = radius;  				// decrement by 1 using P
	P  = 1 - radius;
	bx = b;
	ay = a;

	if (fill)
	{		
		RectangleFill(x1, y1+radius, x2, y2-radius, color);
		
		do
		{
      RectangleFill(x1-a+radius, y1-b+radius, a+x2-radius, y1-b+radius, color);	// 8 --> 1
      RectangleFill(x1-b+radius, y1-a+radius, b+x2-radius, y1-a+radius, color);	// 7 --> 2
      RectangleFill(x1-b+radius, a+y2-radius, b+x2-radius, a+y2-radius, color);	// 6 --> 3
			RectangleFill(x1-a+radius, b+y2-radius, a+x2-radius, b+y2-radius, color);	// 5 --> 4

			if(P < 0)		P+= 3 + 2*a++;
			else				P+= 5 + 2*(a++ - b--);
		} while(a <= b);
	} //fill
	else
	{
		RectangleFill(x1+radius, y1       , x2-radius, y1       , color);	// top
		RectangleFill(x1+radius, y2       , x2-radius, y2       , color);	// bottom
		RectangleFill(x1       , y1+radius, x1       , y2-radius, color);	// left
		RectangleFill(x2       , y1+radius, x2       , y2-radius, color);	// right

		do
		{
			PutPixel(a+x2-radius, y1-b+radius, color);	// `````` Segment 1
			PutPixel(b+x2-radius, y1-a+radius, color);	// `````` Segment 2
			
			PutPixel(b+x2-radius, a+y2-radius, color);	// `````` Segment 3
			PutPixel(a+x2-radius, b+y2-radius, color);	// `````` Segment 4
			
			PutPixel(x1-a+radius, b+y2-radius, color);	// `````` Segment 5
			PutPixel(x1-b+radius, a+y2-radius, color);	// `````` Segment 6
			
			PutPixel(x1-b+radius, y1-a+radius, color);	// `````` Segment 7
			PutPixel(x1-a+radius, y1-b+radius, color);	// `````` Segment 8
			
			if(P < 0)		P+= 3 + 2*a++;
			else				P+= 5 + 2*(a++ - b--);
		} while(a <= b);
	} //no fill
}	//RoundRectangle

// Description	: Draw a circle on the screen. 
// Input       	: x,y  - the center of the circle
//             	: rad  - defines the redius of the circle,
//             	: fill - fill yes or no
//********************************************************************
void Circle_Fill(unsigned int x, unsigned int y, unsigned int radius, unsigned char fill, unsigned short color)
{
   signed int 	a, b, P;
   
   a = 0;
   b = radius;
   P = 1 - radius;

   do
   {
   		if(fill)
     	{
      	RectangleFill(x-a, y+b, x+a, y+b, color);	// 5 --> 4
        RectangleFill(x-a, y-b, x+a, y-b, color);	// 8 --> 1
        RectangleFill(x-b, y+a, x+b, y+a, color);	// 6 --> 3
        RectangleFill(x-b, y-a, x+b, y-a, color);	// 7 --> 2
     	}
     	else
     	{
																		//       		8	1
																		//       	7			2
																		//       	6			3
																		//       		5	4
																		//
       	PutPixel(a+x, b+y, color);	// `````` Segment 4
        PutPixel(b+x, a+y, color);	// `````` Segment 3
        PutPixel(x-a, b+y, color);	// `````` Segment 5
        PutPixel(x-b, a+y, color);	// `````` Segment 6
        PutPixel(b+x, y-a, color);	// `````` Segment 2
        PutPixel(a+x, y-b, color);	// `````` Segment 1
        PutPixel(x-a, y-b, color);	// `````` Segment 8
        PutPixel(x-b, y-a, color);	// `````` Segment 7
      }

      if(P < 0)    P+= 3 + 2*a++;
      else         P+= 5 + 2*(a++ - b--);
    } while(a <= b);
}	//Circle_Fill
