//-----------------------------------------------------------------------------
// Copyright:      RAD Electronic Co. LTD,
// Author:         blue_screen_test_lib_3_12_2008 modefied by Sh. Nourbakhsh Rad
// Remarks:        
// known Problems: none
// Version:        1.5.0
// Description:    ILI9320 & ILI9325 TFT-LCD display driver
//-----------------------------------------------------------------------------

#ifndef _ILI9325_H_
	#define _ILI9325_H_

	#include <inttypes.h>
	#include <avr/io.h>
	#include <avr/pgmspace.h>
	#include <compat/deprecated.h>
	#include <util/delay.h>

	#define LCD_ORN_PORTRAIT										1				// 1 Portrait display : 0 Landscape display *** see below
	
	#define TFT_PORT_INTERFACE									1				// 1 TFT-LCD port interfaced : 0 TFT-LCD memory-mapped interfaced

	// Pins.....
	#if TFT_PORT_INTERFACE
		//--- DATA ---
		#define LCD_DB_DDR												DDRA
		#define LCD_DB_PRT												PORTA
		#define LCD_DB_PIN												PINA
  	
		//--- CTRL ---
		#define LCD_RS_DDR												DDRC
		#define LCD_RS_PRT												PORTC
		#define LCD_RS_BIT												1
		                      										
		#define LCD_CS_DDR												DDRC
		#define LCD_CS_PRT												PORTC
		#define LCD_CS_BIT												0
		                      										
		#define LCD_RD_DDR												DDRC
		#define LCD_RD_PRT												PORTC
		#define LCD_RD_BIT												3
		                      										
		#define LCD_WR_DDR												DDRC
		#define LCD_WR_PRT												PORTC
		#define LCD_WR_BIT												2

		#define LCD_RST_DDR	       								DDRC
		#define LCD_RST_PRT	       								PORTC
		#define LCD_RST_BIT												4
		
		#define LCD_BL_DDR												DDRB
		#define LCD_BL_PRT												PORTB
		#define LCD_BL_BIT												5
	#else
		#define TFT_CTRL_ADDR											0x9000
		#define TFT_DATA_ADDR											0x9200

		#define LCD_RST_DDR	       								DDRD
		#define LCD_RST_PRT	       								PORTD
		#define LCD_RST_BIT												7
		
		#define LCD_BL_DDR												DDRB
		#define LCD_BL_PRT												PORTB
		#define LCD_BL_BIT												5
	#endif
	

	#define LCD_BL_ON                           sbi(LCD_BL_PRT,LCD_BL_BIT)
	#define LCD_BL_OFF                          cbi(LCD_BL_PRT,LCD_BL_BIT)

	// Orientation
	#if LCD_ORN_PORTRAIT
		#define LCD_SIZE_X                        240
		#define LCD_SIZE_Y                        320
		#define LCD_VAL_ENTRY_MOD                 0x0030
		#define LCD_INS_GRAM_ADX                  LCD_INS_GRAM_HOR_AD
		#define LCD_INS_GRAM_ADY                  LCD_INS_GRAM_VER_AD
		#define LCD_INS_START_ADX                 LCD_INS_HOR_START_AD
		#define LCD_INS_END_ADX                   LCD_INS_HOR_END_AD
		#define LCD_INS_START_ADY                 LCD_INS_VER_START_AD
		#define LCD_INS_END_ADY                   LCD_INS_VER_END_AD
	#else
		#define LCD_SIZE_X                        320
		#define LCD_SIZE_Y                        240
		#define LCD_VAL_ENTRY_MOD                 0x0028
		#define LCD_INS_GRAM_ADX                  LCD_INS_GRAM_VER_AD
		#define LCD_INS_GRAM_ADY                  LCD_INS_GRAM_HOR_AD
		#define LCD_INS_START_ADX                 LCD_INS_VER_START_AD
		#define LCD_INS_END_ADX                   LCD_INS_VER_END_AD
		#define LCD_INS_START_ADY                 LCD_INS_HOR_START_AD
		#define LCD_INS_END_ADY                   LCD_INS_HOR_END_AD
	#endif
	
	//*       LCD_ORN_PORTRAIT == 0x00					  LCD_ORN_PORTRAIT == 0x01       *//
	//*                                                                          *//
	//*	        																				  ____________           *//
	//*	                      													 \ ---------- \          *//
	//*	      ________________________                   \\          \\          *//
	//*	     \ ___________________    \                  \\          \\          *//
	//*	     \\                   \[] \                  \\  ------  \\          *//
	//*	     \\   ------------    \[] \                  \\       /  \\          *//
	//*	     \\         /         \[] \                  \\     /    \\          *//
	//*	     \\   ------------>   \[] \ 	               \\   /      \\          *//
	//*	     \\___________________\[] \                  \\  ------> \\          *//
	//*	     \________________________\ 								 \\__________\\          *//
	//*	                                               	 \ [][][][][] \          *//
	//*	                                   							 \____________\          *//
	//*	    																																		 *//
	//*     																																		 *//


	// Commands                 		
	#define LCD_INS_START_OSC										0x00 //data read at this instruction should be 0x0789 --> use for test connection
	#define LCD_INS_DRIV_OUT_CTRL		        		0x01
	#define LCD_INS_DRIV_WAV_CTRL		        		0x02
	#define LCD_INS_ENTRY_MOD										0x03
	#define LCD_INS_RESIZE_CTRL									0x04
	#define LCD_INS_DISP_CTRL1									0x07
	#define LCD_INS_DISP_CTRL2									0x08
	#define LCD_INS_DISP_CTRL3									0x09
	#define LCD_INS_DISP_CTRL4									0x0A
	#define LCD_INS_RGB_DISP_IF_CTRL1	        	0x0C
	#define LCD_INS_FRM_MARKER_POS		        	0x0D
	#define LCD_INS_RGB_DISP_IF_CTRL2	        	0x0F
	#define LCD_INS_POW_CTRL1										0x10
	#define LCD_INS_POW_CTRL2										0x11
	#define LCD_INS_POW_CTRL3										0x12
	#define LCD_INS_POW_CTRL4										0x13
	#define LCD_INS_GRAM_HOR_AD									0x20
	#define LCD_INS_GRAM_VER_AD									0x21
	#define LCD_INS_RW_GRAM											0x22
	#define LCD_INS_POW_CTRL7										0x29
	#define LCD_INS_FRM_RATE_COL_CTRL	        	0x2B
	#define LCD_INS_GAMMA_CTRL1									0x30
	#define LCD_INS_GAMMA_CTRL2									0x31
	#define LCD_INS_GAMMA_CTRL3									0x32
	#define LCD_INS_GAMMA_CTRL4									0x35 
	#define LCD_INS_GAMMA_CTRL5									0x36
	#define LCD_INS_GAMMA_CTRL6									0x37
	#define LCD_INS_GAMMA_CTRL7									0x38
	#define LCD_INS_GAMMA_CTRL8									0x39
	#define LCD_INS_GAMMA_CTRL9									0x3C
	#define LCD_INS_GAMMA_CTRL10								0x3D
	#define LCD_INS_HOR_START_AD								0x50
	#define LCD_INS_HOR_END_AD									0x51
	#define LCD_INS_VER_START_AD								0x52
	#define LCD_INS_VER_END_AD									0x53
	#define LCD_INS_GATE_SCAN_CTRL1		        	0x60
	#define LCD_INS_GATE_SCAN_CTRL2		        	0x61
	#define LCD_INS_GATE_SCAN_CTRL3		        	0x6A
	#define LCD_INS_PART_IMG1_DISP_POS	        0x80
	#define LCD_INS_PART_IMG1_START_AD	        0x81
	#define LCD_INS_PART_IMG1_END_AD		        0x82
	#define LCD_INS_PART_IMG2_DISP_POS	        0x83
	#define LCD_INS_PART_IMG2_START_AD	        0x84
	#define LCD_INS_PART_IMG2_END_AD		        0x85
	#define LCD_INS_PANEL_IF_CTRL1		        	0x90
	#define LCD_INS_PANEL_IF_CTRL2		        	0x92
	#define LCD_INS_PANEL_IF_CTRL3		        	0x93
	#define LCD_INS_PANEL_IF_CTRL4		        	0x95
	#define LCD_INS_PANEL_IF_CTRL5		        	0x97
	#define LCD_INS_PANEL_IF_CTRL6		        	0x98
	
	//Colors
	#define RGB2COL(red, green, blue)						((unsigned int)( (( blue  >> 3 )   << 11 ) | \
																															 (( green >> 2 )   << 5  ) | \
																																( red   >> 3 )))
	
	#define LCD_COL_RED													0x001F
	#define LCD_COL_GREEN												0x07E0
	#define LCD_COL_BLUE												0xF800
	#define LCD_COL_YELLOW											0x07FF
	#define LCD_COL_PURPLE											0xF81F
	#define LCD_COL_BLACK												0x0000
	#define LCD_COL_WHITE												0xFFFF
	
	//RGB Colors																			 (  R ,  G  ,  B  ) from PhotoShop!!!
	#define BLACK                       				RGB2COL(0x00, 0x00, 0x00)
	#define GRAY                        				RGB2COL(0x95, 0x95, 0x95)
	#define WHITE                       				RGB2COL(0xFF, 0xFF, 0xFF)

	#define RED                         				RGB2COL(0xFF, 0x00, 0x00)
	#define LIGHT_RED              			 				RGB2COL(0xF2, 0x6C, 0x4E)
	#define DARK_RED          	  			 				RGB2COL(0x79, 0x00, 0x00)
	
	#define GREEN                       				RGB2COL(0x00, 0xFF, 0x00)
	#define LIGHT_GREEN            	    				RGB2COL(0x3B, 0xB8, 0x78)
	#define DARK_GREEN        			    				RGB2COL(0x00, 0x58, 0x25)
	
	#define BLUE                        				RGB2COL(0x00, 0x00, 0xFF)
	#define LIGHT_BLUE                 					RGB2COL(0x00, 0xBF, 0xF3)
	#define DARK_BLUE           	     					RGB2COL(0x00, 0x5B, 0x7F)

	#define YELLOW                      				RGB2COL(0xFF, 0xFF, 0x00)
	#define LIGHT_YELLOW           	    				RGB2COL(0xFF, 0xF4, 0x68)
	#define DARK_YELLOW        			    				RGB2COL(0xAB, 0xA0, 0x00)
	
	#define MAGENTA                     				RGB2COL(0xFF, 0x00, 0xFF)
	#define CYAN                        				RGB2COL(0x00, 0xFF, 0xFF)
	#define BROWN                  		  				RGB2COL(0xA6, 0x7C, 0x51)
	#define SILVER                      				RGB2COL(0xCC, 0xCC, 0xCC)
	#define GOLD                        				RGB2COL(0xD7, 0xCD, 0x19)
	
	//Variables
	typedef enum {
		LCD_MODE_NORMAL,
	  LCD_MODE_INVERSE,
	  LCD_MODE_FULL
	} LCD_mode_t;
	
	extern int 																	LCD_margin_xl;
	extern int 																	LCD_margin_xr;
	extern int 																	LCD_margin_yu;
	extern int 																	LCD_margin_yl;
	
	#define LCD_CLS(clr)                        LCDFillRect(0, (LCD_SIZE_X-1), 0, (LCD_SIZE_Y-1), clr, LCD_MODE_NORMAL)
	#define LCD_PutPixel(x, y, clr)             LCDFillRect(x, x, y, y, clr, LCD_MODE_NORMAL)

	#define GetMaxX() 													((unsigned int)LCD_SIZE_X-1)
	#define GetMaxY() 													((unsigned int)LCD_SIZE_Y-1)

	#define _NOP() 															asm volatile("nop\n\t")


	//******************* Function Prototypes
	void LCDOutIns(unsigned short ins); //write instruction to LCD
	void LCDOutDat(unsigned short dat); //write data to LCD
	void LCDOutDat2(unsigned char dath,unsigned char datl); //fast write data to LCD
	unsigned short LCDInIns(void); //read data from LCD
	unsigned short LCDInDat(void); //read data from LCD
	
	void LCDRst(void); //pulse reset signal to LCD
	void LCDInit(void); //initial LCD
	void LCDPortInit(void); //initial LCD HW
	
	void buf_store(unsigned char charactor);

	void delay450ns(unsigned char n);

	//////////////////////////////
	void LCDCfgFont(const unsigned char *_font, unsigned char width, unsigned char height_div_8,unsigned char gap); //set font, font size
	
	void LCDSetFontColor(unsigned short color); //set text's color
	void LCDSetBackColor(unsigned short color); //set back color for LCD_MODE_FULL

	void LCDSetOffset(int x,int y); //set LCD offset for character display
	
	void LCDPrintStr(unsigned char line,unsigned char column,char *str,LCD_mode_t mode); //print string on LCD
	void LCDPrintTxt(unsigned char line,unsigned char column,const char *txt,LCD_mode_t mode); //print text from code memory
	void LCDPrintCh(unsigned char line,unsigned char column,char c,LCD_mode_t mode); //print a character on LCD

	void LCDSetBold(unsigned char on); //set bold character mode
	void LCDSetVaryWidth(unsigned char on); //enable variable character width

	unsigned char LCDGetBold(void); //get bold character mode
	unsigned char LCDGetVaryWidth(void); //get variable character width enabling

	unsigned int LCDGetCharWidth(char c); //get printed width of character
	unsigned int LCDGetStringWidth(char *str); //get printed width of string

	void LCDCharDisp(char charactor,int sx,int sy,LCD_mode_t mode); //low level function to print a character on LCD

	//////////////////////////////
	void LCD_print(char c);

	int LCDGetLineY(unsigned char line);
	void LCDSetCursor(unsigned char line,unsigned char column, LCD_mode_t mode);

	//////////////////////////////
	void LCDGotoXY(int x,int y);
	void LCDSetArea(int sx,int ex,int sy,int ey);
	
	void LCDFillRect(int sx,int ex,int sy,int ey,unsigned short color,LCD_mode_t mode); //draw a rectangular
	void LCDPutPixel(int x,int y,unsigned short color,LCD_mode_t mode);
	void LCDFillCirc(int cx,int cy,int rad,unsigned short color, LCD_mode_t mode); //draw a circle

	void LCDSetMargins(int xl,int xr,int yu,int yl); //set margins for FillRect,FillCirc
	void LCDSetMarginsDefault(void); //reset margins to default value

	//show picture from code memory with specific size
	void LCDShowPic2(int sx,int ex,int sy,int ey,const unsigned short *pic,LCD_mode_t mode);

#endif //_ILI9325_H_
