/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import processing.core.PApplet;
import processing.xml.StdXMLBuilder;
import processing.xml.StdXMLParser;
import processing.xml.StdXMLReader;
import processing.xml.XMLAttribute;
import processing.xml.XMLException;
import processing.xml.XMLValidator;
import processing.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement
implements Serializable {
    public static final int NO_LINE = -1;
    private XMLElement parent;
    private Vector<XMLAttribute> attributes = new Vector();
    private Vector<XMLElement> children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, null, -1);
    }

    protected void set(String string, String string2, String string3, int n) {
        int n2;
        this.fullName = string;
        this.name = string2 == null ? string : ((n2 = string.indexOf(58)) >= 0 ? string.substring(n2 + 1) : string);
        this.namespace = string2;
        this.lineNr = n;
        this.systemID = string3;
    }

    public XMLElement(String string, String string2, String string3, int n) {
        int n2;
        this.fullName = string;
        this.name = string2 == null ? string : ((n2 = string.indexOf(58)) >= 0 ? string.substring(n2 + 1) : string);
        this.namespace = string2;
        this.content = null;
        this.lineNr = n;
        this.systemID = string3;
        this.parent = null;
    }

    public XMLElement(PApplet pApplet, String string) {
        this();
        this.parseFromReader(pApplet.createReader(string));
    }

    public XMLElement(Reader reader) {
        this();
        this.parseFromReader(reader);
    }

    public XMLElement(String string) {
        this();
        this.parseFromReader(new StringReader(string));
    }

    protected void parseFromReader(Reader reader) {
        try {
            StdXMLParser stdXMLParser = new StdXMLParser();
            stdXMLParser.setBuilder(new StdXMLBuilder(this));
            stdXMLParser.setValidator(new XMLValidator());
            stdXMLParser.setReader(new StdXMLReader(reader));
            stdXMLParser.parse();
        }
        catch (XMLException xMLException) {
            xMLException.printStackTrace();
        }
    }

    public XMLElement createPCDataElement() {
        return new XMLElement();
    }

    public XMLElement createElement(String string, String string2) {
        return new XMLElement(string, string2, null, -1);
    }

    public XMLElement createElement(String string, String string2, String string3, int n) {
        return new XMLElement(string, string2, string3, n);
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.fullName;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String string) {
        this.name = string;
        this.fullName = string;
        this.namespace = null;
    }

    public void setName(String string, String string2) {
        int n = string.indexOf(58);
        this.name = string2 == null || n < 0 ? string : string.substring(n + 1);
        this.fullName = string;
        this.namespace = string2;
    }

    public void addChild(XMLElement xMLElement) {
        XMLElement xMLElement2;
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (xMLElement.getLocalName() == null && !this.children.isEmpty() && (xMLElement2 = this.children.lastElement()).getLocalName() == null) {
            xMLElement2.setContent(xMLElement2.getContent() + xMLElement.getContent());
            return;
        }
        xMLElement.parent = this;
        this.children.addElement(xMLElement);
    }

    public void insertChild(XMLElement xMLElement, int n) {
        XMLElement xMLElement2;
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (xMLElement.getLocalName() == null && !this.children.isEmpty() && (xMLElement2 = this.children.lastElement()).getLocalName() == null) {
            xMLElement2.setContent(xMLElement2.getContent() + xMLElement.getContent());
            return;
        }
        xMLElement.parent = this;
        this.children.insertElementAt(xMLElement, n);
    }

    public void removeChild(XMLElement xMLElement) {
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(xMLElement);
    }

    public void removeChildAtIndex(int n) {
        this.children.removeElementAt(n);
    }

    public Enumeration<XMLElement> enumerateChildren() {
        return this.children.elements();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public String[] listChildren() {
        int n = this.getChildCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getChild(i).getName();
        }
        return stringArray;
    }

    public XMLElement[] getChildren() {
        int n = this.getChildCount();
        Object[] objectArray = new XMLElement[n];
        this.children.copyInto(objectArray);
        return objectArray;
    }

    public XMLElement getChild(int n) {
        return this.children.elementAt(n);
    }

    public XMLElement getChild(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(string, '/'), 0);
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = this.getChild(i);
            String string2 = xMLElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return xMLElement;
        }
        return null;
    }

    protected XMLElement getChildRecursive(String[] stringArray, int n) {
        if (Character.isDigit(stringArray[n].charAt(0))) {
            XMLElement xMLElement = this.getChild(Integer.parseInt(stringArray[n]));
            if (n == stringArray.length - 1) {
                return xMLElement;
            }
            return xMLElement.getChildRecursive(stringArray, n + 1);
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            XMLElement xMLElement = this.getChild(i);
            String string = xMLElement.getName();
            if (string == null || !string.equals(stringArray[n])) continue;
            if (n == stringArray.length - 1) {
                return xMLElement;
            }
            return xMLElement.getChildRecursive(stringArray, n + 1);
        }
        return null;
    }

    public XMLElement getChildAtIndex(int n) throws ArrayIndexOutOfBoundsException {
        return this.children.elementAt(n);
    }

    public XMLElement[] getChildren(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(string, '/'), 0);
        }
        if (Character.isDigit(string.charAt(0))) {
            return new XMLElement[]{this.getChild(Integer.parseInt(string))};
        }
        int n = this.getChildCount();
        XMLElement[] xMLElementArray = new XMLElement[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement = this.getChild(i);
            String string2 = xMLElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            xMLElementArray[n2++] = xMLElement;
        }
        return (XMLElement[])PApplet.subset(xMLElementArray, 0, n2);
    }

    protected XMLElement[] getChildrenRecursive(String[] stringArray, int n) {
        if (n == stringArray.length - 1) {
            return this.getChildren(stringArray[n]);
        }
        XMLElement[] xMLElementArray = this.getChildren(stringArray[n]);
        XMLElement[] xMLElementArray2 = new XMLElement[]{};
        for (int i = 0; i < xMLElementArray.length; ++i) {
            XMLElement[] xMLElementArray3 = xMLElementArray[i].getChildrenRecursive(stringArray, n + 1);
            xMLElementArray2 = (XMLElement[])PApplet.concat(xMLElementArray2, xMLElementArray3);
        }
        return xMLElementArray2;
    }

    private XMLAttribute findAttribute(String string) {
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            if (!xMLAttribute.getFullName().equals(string)) continue;
            return xMLAttribute;
        }
        return null;
    }

    private XMLAttribute findAttribute(String string, String string2) {
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            boolean bl = xMLAttribute.getName().equals(string);
            bl = string2 == null ? (bl &= xMLAttribute.getNamespace() == null) : (bl &= string2.equals(xMLAttribute.getNamespace()));
            if (!bl) continue;
            return xMLAttribute;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public String getAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return string2;
        }
        return xMLAttribute.getValue();
    }

    public String getAttribute(String string, String string2, String string3) {
        XMLAttribute xMLAttribute = this.findAttribute(string, string2);
        if (xMLAttribute == null) {
            return string3;
        }
        return xMLAttribute.getValue();
    }

    public String getStringAttribute(String string) {
        return this.getAttribute(string);
    }

    public String getStringAttribute(String string, String string2) {
        return this.getAttribute(string, string2);
    }

    public String getStringAttribute(String string, String string2, String string3) {
        return this.getAttribute(string, string2, string3);
    }

    public int getIntAttribute(String string) {
        return this.getIntAttribute(string, 0);
    }

    public int getIntAttribute(String string, int n) {
        String string2 = this.getAttribute(string, Integer.toString(n));
        return Integer.parseInt(string2);
    }

    public int getIntAttribute(String string, String string2, int n) {
        String string3 = this.getAttribute(string, string2, Integer.toString(n));
        return Integer.parseInt(string3);
    }

    public float getFloatAttribute(String string) {
        return this.getFloatAttribute(string, 0.0f);
    }

    public float getFloatAttribute(String string, float f) {
        String string2 = this.getAttribute(string, Float.toString(f));
        return Float.parseFloat(string2);
    }

    public float getFloatAttribute(String string, String string2, float f) {
        String string3 = this.getAttribute(string, string2, Float.toString(f));
        return Float.parseFloat(string3);
    }

    public double getDoubleAttribute(String string) {
        return this.getDoubleAttribute(string, 0.0);
    }

    public double getDoubleAttribute(String string, double d) {
        String string2 = this.getAttribute(string, Double.toString(d));
        return Double.parseDouble(string2);
    }

    public double getDoubleAttribute(String string, String string2, double d) {
        String string3 = this.getAttribute(string, string2, Double.toString(d));
        return Double.parseDouble(string3);
    }

    public String getAttributeType(String string) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getType();
    }

    public String getAttributeNamespace(String string) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getNamespace();
    }

    public String getAttributeType(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string, string2);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getType();
    }

    public void setAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string, string, null, string2, "CDATA");
            this.attributes.addElement(xMLAttribute);
        } else {
            xMLAttribute.setValue(string2);
        }
    }

    public void setAttribute(String string, String string2, String string3) {
        int n = string.indexOf(58);
        String string4 = string.substring(n + 1);
        XMLAttribute xMLAttribute = this.findAttribute(string4, string2);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string, string4, string2, string3, "CDATA");
            this.attributes.addElement(xMLAttribute);
        } else {
            xMLAttribute.setValue(string3);
        }
    }

    public void removeAttribute(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute xMLAttribute = this.attributes.elementAt(i);
            if (!xMLAttribute.getFullName().equals(string)) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public void removeAttribute(String string, String string2) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute xMLAttribute = this.attributes.elementAt(i);
            boolean bl = xMLAttribute.getName().equals(string);
            bl = string2 == null ? (bl &= xMLAttribute.getNamespace() == null) : (bl &= xMLAttribute.getNamespace().equals(string2));
            if (!bl) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    public Enumeration<String> enumerateAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            vector.addElement(xMLAttribute.getFullName());
        }
        return vector.elements();
    }

    public boolean hasAttribute(String string) {
        return this.findAttribute(string) != null;
    }

    public boolean hasAttribute(String string, String string2) {
        return this.findAttribute(string, string2) != null;
    }

    public Properties getAttributes() {
        Properties properties = new Properties();
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            properties.put(xMLAttribute.getFullName(), xMLAttribute.getValue());
        }
        return properties;
    }

    public Properties getAttributesInNamespace(String string) {
        Properties properties = new Properties();
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            if (string == null) {
                if (xMLAttribute.getNamespace() != null) continue;
                properties.put(xMLAttribute.getName(), xMLAttribute.getValue());
                continue;
            }
            if (!string.equals(xMLAttribute.getNamespace())) continue;
            properties.put(xMLAttribute.getName(), xMLAttribute.getValue());
        }
        return properties;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public boolean equals(Object object) {
        try {
            return this.equalsXMLElement((XMLElement)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equalsXMLElement(XMLElement xMLElement) {
        Object object;
        Object object2;
        if (!this.name.equals(xMLElement.getLocalName())) {
            return false;
        }
        if (this.attributes.size() != xMLElement.getAttributeCount()) {
            return false;
        }
        Enumeration<XMLAttribute> enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = enumeration.nextElement();
            if (!xMLElement.hasAttribute(xMLAttribute.getName(), xMLAttribute.getNamespace())) {
                return false;
            }
            object2 = xMLElement.getAttribute(xMLAttribute.getName(), xMLAttribute.getNamespace(), null);
            if (!xMLAttribute.getValue().equals(object2)) {
                return false;
            }
            object = xMLElement.getAttributeType(xMLAttribute.getName(), xMLAttribute.getNamespace());
            if (xMLAttribute.getType().equals(object)) continue;
            return false;
        }
        if (this.children.size() != xMLElement.getChildCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            object2 = this.getChildAtIndex(i);
            if (((XMLElement)object2).equalsXMLElement((XMLElement)(object = xMLElement.getChildAtIndex(i)))) continue;
            return false;
        }
        return true;
    }

    public String toString(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
        try {
            if (bl) {
                xMLWriter.write(this, true, 2, true);
            } else {
                xMLWriter.write(this, false, 0, true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }
}

