// 2.4″ TFT Touchscreen Shield For Arduino
// Sample     : Rotation
// Company    : AftabRayaneh
// Website    : http://shop.aftabrayaneh.com
// Editor     : http://forum.arduino.ir/members/omseven-220/
// Date       : 09.02.2014
// Version    : 1.0
//------------------------------------------------------------------
// Arduino Pin 	LCD Shield Pin 	       Use
// 3.3V 	3.3V 	               Power
// 5V 	        5V      	       Power
// GND  	GND 	               Power
// A0 	        LCD_RD 	               LCD Control
// A1 	        LCD_WR   TOUCH_YP      LCD Control / Touch Data
// A2 	        LCD_RS   TOUCH_XM      LCD Control / Touch Data
// A3    	LCD_CS       	       LCD Control
// A4    	LCD_RST 	       LCD Reset
// D2   	LCD_D2   	       LCD Data
// D3   	LCD_D3   	       LCD Data
// D4   	LCD_D4   	       LCD Data
// D5   	LCD_D5   	       LCD Data
// D6   	LCD_D6 / TOUCH XP      LCD Data/ Touch Data
// D7   	LCD_D7 / TOUCH YM      LCD Data / Touch Data
// D8   	LCD_D0 	               LCD Data
// D9   	LCD_D1                 LCD Data
// D11   	SD_DI 	               SD Data
// D12   	SD_DO 	               SD Data
// D13   	SD_SCK 	               SD Clock
//-----------------------------------------------------------------

#include <Adafruit_GFX.h>    // Core graphics library
#include <SWTFT.h> // Hardware-specific library



// Assign human-readable names to some common 16-bit color values:
#define	BLACK   0x0000
#define	BLUE    0x001F
#define	RED     0xF800
#define	GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

SWTFT tft;


void setup(void) {
  Serial.begin(9600);
  Serial.println(F("TFT LCD test"));



  tft.reset();

  uint16_t identifier = tft.readID();

 
  tft.begin(identifier);

  tft.fillScreen(BLACK);

  Serial.println(F("This is a test of the rotation capabilities of the TFT library!"));
  Serial.println(F("Press <SEND> (or type a character) to advance"));
}

void loop(void) {
  rotatePixel();
  rotateLine();
  rotateFastline();
  rotateDrawrect();
  rotateFillrect();
  rotateDrawcircle();
  rotateFillcircle();
  rotateText();
}

void rotateText() {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.setCursor(0, 30);
    tft.setTextColor(RED);
    tft.setTextSize(1);
    tft.println("Hello World!");
    tft.setTextColor(YELLOW);
    tft.setTextSize(2);
    tft.println("Hello World!");
    tft.setTextColor(GREEN);
    tft.setTextSize(3);
    tft.println("Hello World!");
    tft.setTextColor(BLUE);
    tft.setTextSize(4);
    tft.print(1234.567);

    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateFillcircle(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.fillCircle(10, 30, 10, YELLOW);

    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateDrawcircle(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.drawCircle(10, 30, 10, YELLOW);

    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateFillrect(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.fillRect(10, 20, 10, 20, GREEN);

    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateDrawrect(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.drawRect(10, 20, 10, 20, GREEN);

    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateFastline(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.drawFastHLine(0, 20, tft.width(), RED);
    tft.drawFastVLine(20, 0, tft.height(), BLUE);

    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateLine(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.drawLine(tft.width()/2, tft.height()/2, 0, 0, RED);
    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotatePixel(void) {
  for (uint8_t i=0; i<4; i++) {
    tft.fillScreen(BLACK);
    Serial.println(tft.getRotation(), DEC);

    tft.drawPixel(10,20, RED);
    while (!Serial.available());
    Serial.read();  Serial.read();  Serial.read();

    tft.setRotation(tft.getRotation()+1);
  }
}

