// 2.4″ TFT Touchscreen Shield For Arduino
// Sample     : Shape
// Company    : AftabRayaneh
// Website    : http://shop.aftabrayaneh.com
// Editor     : http://forum.arduino.ir/members/omseven-220/
// Date       : 09.02.2014
// Version    : 1.0
//------------------------------------------------------------------
// Arduino Pin 	LCD Shield Pin 	       Use
// 3.3V 	3.3V 	               Power
// 5V 	        5V      	       Power
// GND  	GND 	               Power
// A0 	        LCD_RD 	               LCD Control
// A1 	        LCD_WR   TOUCH_YP      LCD Control / Touch Data
// A2 	        LCD_RS   TOUCH_XM      LCD Control / Touch Data
// A3    	LCD_CS       	       LCD Control
// A4    	LCD_RST 	       LCD Reset
// D2   	LCD_D2   	       LCD Data
// D3   	LCD_D3   	       LCD Data
// D4   	LCD_D4   	       LCD Data
// D5   	LCD_D5   	       LCD Data
// D6   	LCD_D6 / TOUCH XP      LCD Data/ Touch Data
// D7   	LCD_D7 / TOUCH YM      LCD Data / Touch Data
// D8   	LCD_D0 	               LCD Data
// D9   	LCD_D1                 LCD Data
// D11   	SD_DI 	               SD Data
// D12   	SD_DO 	               SD Data
// D13   	SD_SCK 	               SD Clock
//-----------------------------------------------------------------
#include <stdint.h>
#include <TouchScreen.h>
#include <Adafruit_GFX.h>    // Core graphics library
#include <SWTFT.h> // Hardware-specific library

#define	BLACK   0x0000
#define	BLUE    0x001F
#define	RED     0xF800
#define	GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF


#define YP A1  // must be an analog pin, use "An" notation!
#define XM A2  // must be an analog pin, use "An" notation!
#define YM 7   // can be a digital pin
#define XP 6   // can be a digital pin



SWTFT tft;
void setup()
{
  tft.reset();

  uint16_t identifier = tft.readID();

 
  tft.begin(identifier);

  tft.fillScreen(BLACK);
}

void loop()
{
   for(int r=0;r<115;r=r+2)
   {
       tft.drawCircle(120,160, r, YELLOW);
   }
  
}
