// 2.4″ TFT Touchscreen Shield For Arduino
// Sample     : Touchscreen
// Company    : AftabRayaneh
// Website    : http://shop.aftabrayaneh.com
// Editor     : http://forum.arduino.ir/members/omseven-220/
// Date       : 09.02.2014
// Version    : 1.0
//------------------------------------------------------------------
// Arduino Pin 	LCD Shield Pin 	       Use
// 3.3V 	3.3V 	               Power
// 5V 	        5V      	       Power
// GND  	GND 	               Power
// A0 	        LCD_RD 	               LCD Control
// A1 	        LCD_WR   TOUCH_YP      LCD Control / Touch Data
// A2 	        LCD_RS   TOUCH_XM      LCD Control / Touch Data
// A3    	LCD_CS       	       LCD Control
// A4    	LCD_RST 	       LCD Reset
// D2   	LCD_D2   	       LCD Data
// D3   	LCD_D3   	       LCD Data
// D4   	LCD_D4   	       LCD Data
// D5   	LCD_D5   	       LCD Data
// D6   	LCD_D6 / TOUCH XP      LCD Data/ Touch Data
// D7   	LCD_D7 / TOUCH YM      LCD Data / Touch Data
// D8   	LCD_D0 	               LCD Data
// D9   	LCD_D1                 LCD Data
// D11   	SD_DI 	               SD Data
// D12   	SD_DO 	               SD Data
// D13   	SD_SCK 	               SD Clock
//-----------------------------------------------------------------
// Touch screen library with X Y and Z (pressure) readings as well
// as oversampling to avoid 'bouncing'
// This demo code returns raw readings, public domain

#include <stdint.h>
#include "TouchScreen.h"

#define YP A1  // must be an analog pin, use "An" notation!
#define XM A2  // must be an analog pin, use "An" notation!
#define YM 7   // can be a digital pin
#define XP 6   // can be a digital pin

// For better pressure precision, we need to know the resistance
// between X+ and X- Use any multimeter to read it
// For the one we're using, its 300 ohms across the X plate
TouchScreen ts = TouchScreen(XP, YP, XM, YM, 364);

void setup(void) {
  Serial.begin(9600);
}

void loop(void) {
  // a point object holds x y and z coordinates
  Point p = ts.getPoint();
  
  // we have some minimum pressure we consider 'valid'
  // pressure of 0 means no pressing!
  if (p.z > ts.pressureThreshhold) {
     Serial.print("X = "); Serial.print(p.x);
     Serial.print("\tY = "); Serial.print(p.y);
     Serial.print("\tPressure = "); Serial.println(p.z);
  }

  delay(100);
}
